/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.scalatraits.TRedstoneTile;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.CoreSPH;
import mrtjp.projectred.core.Messenger;
import mrtjp.projectred.transmission.IRedwireEmitter;
import mrtjp.projectred.transmission.IRedwirePart;
import mrtjp.projectred.transmission.WirePart;
import mrtjp.projectred.transmission.WirePropogator;

public abstract class RedwirePart
extends WirePart
implements IRedwirePart,
IFaceRedstonePart {
    public byte signal;

    @Override
    public void save(by by2) {
        super.save(by2);
        by2.a("signal", this.signal);
    }

    @Override
    public void load(by by2) {
        super.load(by2);
        this.signal = by2.c("signal");
    }

    @Override
    public void writeDesc(MCDataOutput mCDataOutput) {
        super.writeDesc(mCDataOutput);
        mCDataOutput.writeByte((int)this.signal);
    }

    @Override
    public void readDesc(MCDataInput mCDataInput) {
        super.readDesc(mCDataInput);
        this.signal = mCDataInput.readByte();
    }

    @Override
    public void read(MCDataInput mCDataInput, int n) {
        if (n == 10) {
            this.signal = mCDataInput.readByte();
            if (this.useStaticRenderer()) {
                this.tile().markRender();
            }
        } else {
            super.read(mCDataInput, n);
        }
    }

    public int strongPowerLevel(int n) {
        return 0;
    }

    public int weakPowerLevel(int n) {
        if ((n & 6) != (this.side & 6) && (this.connMap & 256 << Rotation.rotationTo((int)this.side, (int)n)) != 0) {
            return 0;
        }
        return this.rsLevel();
    }

    public boolean canConnectRedstone(int n) {
        return WirePropogator.redwiresConnectable();
    }

    public int rsLevel() {
        if (WirePropogator.redwiresProvidePower) {
            return ((this.signal & 0xFF) + 16) / 17;
        }
        return 0;
    }

    public int getFace() {
        return this.side;
    }

    @Override
    public boolean connectionOpen(int n) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        return (((TRedstoneTile)this.tile()).openConnections(n2) & 1 << Rotation.rotationTo((int)(n2 & 6), (int)this.side)) != 0;
    }

    @Override
    public boolean canConnectToType(IConnectable iConnectable) {
        return iConnectable instanceof IRedwireEmitter || iConnectable instanceof IRedstonePart;
    }

    @Override
    public boolean connectStraightOverride(int n) {
        return (RedstoneInteractions.otherConnectionMask((acf)this.world(), (int)this.x(), (int)this.y(), (int)this.z(), (int)n, (boolean)false) & RedstoneInteractions.connectionMask((TMultiPart)this, (int)n)) != 0;
    }

    @Override
    public boolean connectInternalOverride(TMultiPart tMultiPart, int n) {
        if (tMultiPart instanceof IFaceRedstonePart) {
            IRedstonePart iRedstonePart = (IRedstonePart)tMultiPart;
            return iRedstonePart.canConnectRedstone((int)this.side);
        }
        return false;
    }

    @Override
    public void updateAndPropogate(TMultiPart tMultiPart, int n) {
        if (n == 1 && this.signal == 0) {
            return;
        }
        int n2 = this.calculateSignal();
        if (n2 < this.getRedwireSignal()) {
            if (n2 > 0) {
                WirePropogator.propogateAnalogDrop(this);
            }
            this.signal = 0;
            this.propogate(tMultiPart, 1);
        } else if (n2 > this.getRedwireSignal()) {
            this.signal = (byte)n2;
            if (n == 1) {
                this.propogate(null, 0);
            } else {
                this.propogate(tMultiPart, 0);
            }
        } else if (n == 1) {
            this.propogateTo(tMultiPart, 0);
        } else if (n == 2) {
            this.propogate(tMultiPart, 3);
        }
    }

    @Override
    public void onSignalUpdate() {
        super.onSignalUpdate();
        this.tile().getWriteStream((TMultiPart)this).writeByte(10).writeByte((int)this.signal);
    }

    public int calculateSignal() {
        int n;
        WirePropogator.setWiresProvidePower(false);
        WirePropogator.redwiresProvidePower = false;
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.maskConnects(i)) continue;
            if ((this.connMap & 1 << i) != 0) {
                n = this.calculateCornerSignal(i);
                if (n <= n2) continue;
                n2 = n;
                continue;
            }
            if ((this.connMap & 16 << i) != 0 && (n = this.calculateStraightSignal(i)) > n2) {
                n2 = n;
            }
            if ((n = this.calculateInternalSignal(i)) <= n2) continue;
            n2 = n;
        }
        n = this.calculateUndersideSignal();
        if (n > n2) {
            n2 = n;
        }
        if ((this.connMap & 0x10000) != 0 && (n = this.calculateCenterSignal()) > n2) {
            n2 = n;
        }
        WirePropogator.setWiresProvidePower(true);
        WirePropogator.redwiresProvidePower = true;
        return n2;
    }

    public int calculateCornerSignal(int n) {
        TMultiPart tMultiPart;
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2);
        BlockCoord blockCoord2 = blockCoord.copy().offset((int)this.side);
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord2);
        if (tileMultipart != null && (tMultiPart = tileMultipart.partMap(n2 ^ 1)) != null) {
            return this.getPartSignal(tMultiPart, Rotation.rotationTo((int)(n2 ^ 1), (int)(this.side ^ 1)));
        }
        return 0;
    }

    public int calculateStraightSignal(int n) {
        TMultiPart tMultiPart;
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2);
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null && (tMultiPart = tileMultipart.partMap((int)this.side)) != null) {
            return this.getPartSignal(tMultiPart, (n + 2) % 4);
        }
        int n3 = this.world().a(blockCoord.x, blockCoord.y, blockCoord.z);
        if (n3 == aqz.aA.cF) {
            return this.world().h(blockCoord.x, blockCoord.y, blockCoord.z) - 1;
        }
        return RedstoneInteractions.getPowerTo((TMultiPart)this, (int)n2) * 17;
    }

    public int calculateInternalSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side, (int)n);
        TMultiPart tMultiPart = this.tile().partMap(n2);
        return this.getPartSignal(tMultiPart, Rotation.rotationTo((int)n2, (int)this.side));
    }

    public int calculateCenterSignal() {
        return this.getPartSignal(this.tile().partMap(6), this.side);
    }

    public int calculateUndersideSignal() {
        return 0;
    }

    public int getPartSignal(TMultiPart tMultiPart, int n) {
        if (tMultiPart instanceof IRedwirePart && ((IRedwirePart)tMultiPart).isWireSide(n)) {
            return ((IRedwirePart)tMultiPart).getRedwireSignal(n) - 1;
        }
        if (tMultiPart instanceof IRedwireEmitter) {
            return ((IRedwireEmitter)tMultiPart).getRedwireSignal(n);
        }
        if (tMultiPart instanceof IFaceRedstonePart) {
            IFaceRedstonePart iFaceRedstonePart = (IFaceRedstonePart)tMultiPart;
            int n2 = Rotation.rotateSide((int)iFaceRedstonePart.getFace(), (int)n);
            return Math.max(iFaceRedstonePart.strongPowerLevel(n2), iFaceRedstonePart.weakPowerLevel(n2)) * 17;
        }
        return 0;
    }

    public int getRedwireSignal() {
        return this.signal & 0xFF;
    }

    @Override
    public int getRedwireSignal(int n) {
        return this.getRedwireSignal();
    }

    @Override
    protected boolean debug(uf uf2) {
        uf2.a(cv.e((String)((this.world().I ? "Client" : "Server") + " signal strength: " + this.getRedwireSignal())));
        return true;
    }

    @Override
    protected boolean test(uf uf2) {
        if (BasicUtils.isClient((abw)this.world())) {
            Messenger.addMessage((double)this.x(), (double)((float)this.y() + 0.5f), (double)this.z(), (String)("/#f/#c[c] = " + this.getRedwireSignal()));
        } else {
            PacketCustom packetCustom = new PacketCustom((Object)CoreSPH.channel(), CoreSPH.messagePacket());
            packetCustom.writeDouble((double)this.x() + 0.0);
            packetCustom.writeDouble((double)this.y() + 0.5);
            packetCustom.writeDouble((double)this.z() + 0.0);
            packetCustom.writeString("/#c[s] = " + this.getRedwireSignal());
            packetCustom.sendToPlayer(uf2);
        }
        return true;
    }
}

