/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.IRandomDisplayTick;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.handler.MultipartProxy;
import java.util.Random;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.integration.GatePart;
import mrtjp.projectred.integration.RedstoneGateLogic;
import mrtjp.projectred.integration.RenderGate;
import mrtjp.projectred.transmission.IRedwireEmitter;

public abstract class RedstoneGatePart
extends GatePart
implements IFaceRedstonePart,
IRandomDisplayTick {
    @Override
    public abstract RedstoneGateLogic getLogic();

    public int strongPowerLevel(int n) {
        if ((n & 6) == (this.side() & 6)) {
            return 0;
        }
        return this.getLogic().getOutput(this, this.relRot(n));
    }

    public int weakPowerLevel(int n) {
        return this.strongPowerLevel(n);
    }

    public boolean canConnectRedstone(int n) {
        if ((n & 6) == (this.side() & 6)) {
            return false;
        }
        return this.getLogic().canConnect(this, this.relRot(n));
    }

    public int getFace() {
        return this.side();
    }

    @Override
    public void notifyNeighbors(int n) {
        int n2 = 0;
        int n3 = MultipartProxy.block().cF;
        BlockCoord blockCoord = new BlockCoord();
        BlockCoord blockCoord2 = new BlockCoord();
        for (int i = 0; i < 4; ++i) {
            if ((n & 1 << i) == 0) continue;
            int n4 = Rotation.rotateSide((int)this.side(), (int)i);
            blockCoord.set(this.x(), this.y(), this.z()).offset(n4);
            this.world().g(blockCoord.x, blockCoord.y, blockCoord.z, n3);
            for (int j = 0; j < 6; ++j) {
                if (j == (n4 ^ 1) || (n2 & 1 << j) != 0) continue;
                blockCoord2.set(blockCoord).offset(j);
                this.world().g(blockCoord2.x, blockCoord2.y, blockCoord2.z, n3);
            }
            n2 |= 1 << n4;
        }
    }

    public int getRedstoneInput(int n) {
        if ((this.connMap & 1 << (n = this.toAbsolute(n))) != 0) {
            return this.calculateCornerSignal(n);
        }
        if ((this.connMap & 16 << n) != 0) {
            return this.calculateStraightSignal(n);
        }
        if ((this.connMap & 256 << n) != 0) {
            return this.calculateInternalSignal(n);
        }
        return this.calculateRedstoneSignal(n);
    }

    public int calculateRedstoneSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        int n3 = RedstoneInteractions.getPowerTo((TMultiPart)this, (int)n2) * 17;
        if (n3 > 0 || this.getLogic().requireStrongInput(n)) {
            return n3;
        }
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2);
        if (this.world().u(blockCoord.x, blockCoord.y, blockCoord.z)) {
            return this.world().B(blockCoord.x, blockCoord.y, blockCoord.z) * 17;
        }
        return 0;
    }

    public int calculateCornerSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2).offset(this.side());
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null) {
            return this.getPartSignal(tileMultipart.partMap(n2 ^ 1), Rotation.rotationTo((int)(n2 ^ 1), (int)(this.side() ^ 1)));
        }
        return 0;
    }

    public int calculateStraightSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2);
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null) {
            return this.getPartSignal(tileMultipart.partMap(this.side()), (n + 2) % 4);
        }
        return 0;
    }

    public int calculateInternalSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        TMultiPart tMultiPart = this.tile().partMap(n2);
        int n3 = this.getPartSignal(tMultiPart, Rotation.rotationTo((int)n2, (int)this.side()));
        if (n3 > 0) {
            return n3;
        }
        if (tMultiPart instanceof IRedstonePart) {
            IRedstonePart iRedstonePart = (IRedstonePart)tMultiPart;
            return Math.max(iRedstonePart.strongPowerLevel(this.side()), iRedstonePart.weakPowerLevel(this.side())) << 4;
        }
        return 0;
    }

    public int getPartSignal(TMultiPart tMultiPart, int n) {
        if (tMultiPart instanceof IRedwireEmitter) {
            return ((IRedwireEmitter)tMultiPart).getRedwireSignal(n);
        }
        return 0;
    }

    public void randomDisplayTick(Random random) {
        RenderGate.spawnParticles(this, random);
    }
}

