/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.integration.BundledGateLogic;
import mrtjp.projectred.integration.SimpleGatePart;

public class BundledGatePart
extends SimpleGatePart
implements IBundledEmitter {
    public BundledGateLogic logic;

    @Override
    public BundledGateLogic getLogic() {
        return this.logic;
    }

    @Override
    public String getType() {
        return "pr_bgate";
    }

    @Override
    public boolean connectStraightOverride(int n) {
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n);
        asp asp2 = this.world().r(blockCoord.x, blockCoord.y, blockCoord.z);
        if (asp2 instanceof IBundledTile) {
            return ((IBundledTile)asp2).canConnectBundled(n ^ 1);
        }
        return false;
    }

    public byte[] getBundledInput(int n) {
        if ((this.connMap & 1 << (n = this.toAbsolute(n))) != 0) {
            return this.calculateBundledCornerSignal(n);
        }
        if ((this.connMap & 16 << n) != 0) {
            return this.calculateBundledStraightSignal(n);
        }
        if ((this.connMap & 256 << n) != 0) {
            return this.calculateBundledInternalSignal(n);
        }
        return null;
    }

    public byte[] calculateBundledCornerSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2).offset(this.side());
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null) {
            return this.getBundledPartSignal(tileMultipart.partMap(n2 ^ 1), Rotation.rotationTo((int)(n2 ^ 1), (int)(this.side() ^ 1)));
        }
        return null;
    }

    public byte[] calculateBundledStraightSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2);
        asp asp2 = this.world().r(blockCoord.x, blockCoord.y, blockCoord.z);
        if (asp2 instanceof IBundledEmitter) {
            return this.getBundledPartSignal(asp2, n2 ^ 1);
        }
        if (asp2 instanceof TileMultipart) {
            return this.getBundledPartSignal(((TileMultipart)asp2).partMap(this.side()), (n + 2) % 4);
        }
        return null;
    }

    public byte[] calculateBundledInternalSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        TMultiPart tMultiPart = this.tile().partMap(n2);
        return this.getBundledPartSignal(tMultiPart, Rotation.rotationTo((int)n2, (int)this.side()));
    }

    public byte[] getBundledPartSignal(Object object, int n) {
        if (object instanceof IBundledEmitter) {
            return ((IBundledEmitter)object).getBundledSignal(n);
        }
        return null;
    }

    @Override
    public void load(by by2) {
        super.load(by2);
        this.logic = BundledGateLogic.create(this, this.subID);
        this.logic.load(by2);
    }

    @Override
    public void save(by by2) {
        super.save(by2);
        this.logic.save(by2);
    }

    @Override
    public void writeDesc(MCDataOutput mCDataOutput) {
        super.writeDesc(mCDataOutput);
        this.logic.writeDesc(mCDataOutput);
    }

    @Override
    public void readDesc(MCDataInput mCDataInput) {
        super.readDesc(mCDataInput);
        if (this.logic == null) {
            this.logic = BundledGateLogic.create(this, this.subID);
        }
        this.logic.readDesc(mCDataInput);
    }

    @Override
    public void read(MCDataInput mCDataInput, int n) {
        if (n <= 10) {
            super.read(mCDataInput, n);
        } else {
            this.logic.read(mCDataInput, n);
        }
    }

    @Override
    public void preparePlacement(uf uf2, BlockCoord blockCoord, int n, int n2) {
        super.preparePlacement(uf2, blockCoord, n, n2);
        this.logic = BundledGateLogic.create(this, this.subID);
    }

    public byte[] getBundledSignal(int n) {
        int n2 = this.toInternal(n);
        return (this.getLogic().bundledOutputMask(this.shape()) & 1 << n2) != 0 ? this.getLogic().getBundledOutput(this, n2) : null;
    }
}

