/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.IRandomDisplayTick;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.Arrays;
import java.util.Random;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.integration.ArrayCommons;
import mrtjp.projectred.integration.ArrayGateLogic;
import mrtjp.projectred.integration.EnumGate;
import mrtjp.projectred.integration.GatePart;
import mrtjp.projectred.integration.RenderGate;
import mrtjp.projectred.transmission.IRedwireEmitter;
import mrtjp.projectred.transmission.IRedwirePart;
import mrtjp.projectred.transmission.IWirePart;
import mrtjp.projectred.transmission.WirePropogator;

public class ArrayGatePart
extends GatePart
implements IRedwirePart,
IFaceRedstonePart,
IRandomDisplayTick,
ArrayCommons.ITopArrayWire {
    public byte signal1;
    public byte signal2;
    public byte state;

    @Override
    public ArrayGateLogic getLogic() {
        return ArrayGateLogic.logic[this.subID - EnumGate.NullCell.ordinal()];
    }

    @Override
    public String getType() {
        return "pr_agate";
    }

    public int state() {
        return this.state & 0xFF;
    }

    public void setState(int n) {
        this.state = (byte)n;
    }

    public void sendStateUpdate() {
        this.getWriteStream(11).writeByte((int)this.state);
    }

    @Override
    public void save(by by2) {
        super.save(by2);
        by2.a("s1", this.signal1);
        by2.a("s2", this.signal2);
        by2.a("state", this.state);
    }

    @Override
    public void load(by by2) {
        super.load(by2);
        this.signal1 = by2.c("s1");
        this.signal2 = by2.c("s2");
        this.state = by2.c("state");
    }

    @Override
    public void writeDesc(MCDataOutput mCDataOutput) {
        super.writeDesc(mCDataOutput);
        mCDataOutput.writeByte((int)this.signal1);
        mCDataOutput.writeByte((int)this.signal2);
        mCDataOutput.writeByte((int)this.state);
    }

    @Override
    public void readDesc(MCDataInput mCDataInput) {
        super.readDesc(mCDataInput);
        this.signal1 = mCDataInput.readByte();
        this.signal2 = mCDataInput.readByte();
        this.state = mCDataInput.readByte();
    }

    @Override
    public void read(MCDataInput mCDataInput, int n) {
        if (n == 10) {
            this.signal1 = mCDataInput.readByte();
            this.signal2 = mCDataInput.readByte();
            if (Configurator.staticGates) {
                this.tile().markRender();
            }
        } else if (n == 11) {
            this.state = mCDataInput.readByte();
            if (Configurator.staticGates) {
                this.tile().markRender();
            }
        } else {
            super.read(mCDataInput, n);
        }
    }

    @Override
    public void updateAndPropogate(TMultiPart tMultiPart, int n) {
        int n2 = this.wireMask(tMultiPart);
        if ((n2 & 1) != 0) {
            this.updateAndPropogate(0, tMultiPart, n);
        }
        if ((n2 & 2) != 0) {
            this.updateAndPropogate(1, tMultiPart, n);
        }
    }

    private void updateAndPropogate(int n, TMultiPart tMultiPart, int n2) {
        int n3 = this.getRedwireSignal(this.toAbsolute(n));
        if (n2 == 1 && n3 == 0) {
            return;
        }
        int n4 = 5 << n;
        int n5 = this.calculateSignal(n4);
        if (n5 < n3) {
            if (n5 > 0) {
                WirePropogator.propogateAnalogDrop(this);
            }
            this.setRedwireSignal(n, 0);
            this.propogate(n4, tMultiPart, 1);
        } else if (n5 > n3) {
            this.setRedwireSignal(n, n5);
            if (n2 == 1) {
                this.propogate(n4, null, 0);
            } else {
                this.propogate(n4, tMultiPart, 0);
            }
        } else if (n2 == 1) {
            this.propogateTo(tMultiPart, 0);
        } else if (n2 == 2) {
            this.propogate(n4, tMultiPart, 3);
        }
    }

    public int calculateSignal(int n) {
        if (n == 10 && this.getLogic().powerUp(this.state())) {
            return 255;
        }
        WirePropogator.setWiresProvidePower(false);
        WirePropogator.redwiresProvidePower = false;
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            int n3;
            if ((n & 1 << this.toInternal(i)) == 0 || (n3 = (this.connMap & 1 << i) != 0 ? this.calculateCornerSignal(i) : this.calculateStraightSignal(i)) <= n2) continue;
            n2 = n3;
        }
        WirePropogator.setWiresProvidePower(true);
        WirePropogator.redwiresProvidePower = true;
        return n2;
    }

    public int calculateCornerSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2);
        BlockCoord blockCoord2 = blockCoord.copy().offset(this.side());
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord2);
        if (tileMultipart != null) {
            return this.getPartSignal(tileMultipart.partMap(n2 ^ 1), Rotation.rotationTo((int)(n2 ^ 1), (int)(this.side() ^ 1)));
        }
        return 0;
    }

    public int calculateStraightSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        int n3 = 0;
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2);
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null && (this.connMap & 16 << n) != 0) {
            TMultiPart tMultiPart = tileMultipart.partMap(this.side());
            if (tMultiPart != null) {
                n3 = this.getPartSignal(tMultiPart, (n + 2) % 4);
            }
        } else {
            int n4 = this.world().a(blockCoord.x, blockCoord.y, blockCoord.z);
            if (n4 == aqz.aA.cF) {
                return this.world().h(blockCoord.x, blockCoord.y, blockCoord.z) - 1;
            }
        }
        int n5 = this.calculateRedstoneSignal(n);
        if (n5 > n3) {
            n3 = n5;
        }
        return n3;
    }

    public int calculateRedstoneSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        int n3 = RedstoneInteractions.getPowerTo((TMultiPart)this, (int)n2) * 17;
        if (n3 > 0) {
            return n3;
        }
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2);
        return this.world().l(blockCoord.x, blockCoord.y, blockCoord.z, n2) * 17;
    }

    public int getPartSignal(TMultiPart tMultiPart, int n) {
        if (tMultiPart instanceof IRedwirePart && ((IRedwirePart)tMultiPart).isWireSide(n)) {
            return ((IRedwirePart)tMultiPart).getRedwireSignal(n) - 1;
        }
        if (tMultiPart instanceof IRedwireEmitter) {
            return ((IRedwireEmitter)tMultiPart).getRedwireSignal(n);
        }
        return 0;
    }

    public void setRedwireSignal(int n, int n2) {
        if (n == 0) {
            this.signal1 = (byte)n2;
        } else {
            this.signal2 = (byte)n2;
        }
    }

    @Override
    public void onSignalUpdate() {
        this.tile().markDirty();
        super.onChange();
        this.getWriteStream(10).writeByte((int)this.signal1).writeByte((int)this.signal2);
    }

    public void propogate(int n, TMultiPart tMultiPart, int n2) {
        if (n2 != 3) {
            WirePropogator.addPartChange((TMultiPart)this);
        }
        for (int i = 0; i < 4; ++i) {
            if ((n & 1 << this.toInternal(i)) == 0) continue;
            if ((this.connMap & 1 << i) != 0) {
                this.propogateCorner(i, tMultiPart, n2);
                continue;
            }
            this.propogateStraight(i, tMultiPart, n2);
        }
    }

    public void propogateCorner(int n, TMultiPart tMultiPart, int n2) {
        int n3 = Rotation.rotateSide((int)this.side(), (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n3).offset(this.side());
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null) {
            TMultiPart tMultiPart2 = tileMultipart.partMap(n3 ^ 1);
            if (tMultiPart2 == tMultiPart) {
                return;
            }
            if (this.propogateTo(tMultiPart2, n2)) {
                return;
            }
        }
        WirePropogator.addNeighborChange(blockCoord);
    }

    public void propogateStraight(int n, TMultiPart tMultiPart, int n2) {
        int n3 = Rotation.rotateSide((int)this.side(), (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n3);
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null) {
            TMultiPart tMultiPart2 = tileMultipart.partMap(this.side());
            if (tMultiPart2 == tMultiPart) {
                return;
            }
            if (this.propogateTo(tMultiPart2, n2)) {
                return;
            }
        }
        WirePropogator.addNeighborChange(blockCoord);
    }

    public int wireMask(TMultiPart tMultiPart) {
        if (tMultiPart.tile() == null) {
            return 3;
        }
        if (this.sideDiff(tMultiPart) == Rotation.rotateSide((int)this.side(), (int)this.toAbsolute(0)) >> 1) {
            return 1;
        }
        return 2;
    }

    public int sideDiff(TMultiPart tMultiPart) {
        int n = this.side() >> 1;
        if (n != 0 && this.y() != tMultiPart.y()) {
            return 0;
        }
        if (n != 1 && this.z() != tMultiPart.z()) {
            return 1;
        }
        return 2;
    }

    public boolean propogateTo(TMultiPart tMultiPart, int n) {
        if (tMultiPart instanceof IWirePart) {
            WirePropogator.propogateTo((IWirePart)tMultiPart, (TMultiPart)this, n);
            return true;
        }
        return false;
    }

    @Override
    public int getRedwireSignal(int n) {
        return (this.toInternal(n) % 2 == 0 ? this.signal1 : this.signal2) & 0xFF;
    }

    public void randomDisplayTick(Random random) {
        RenderGate.spawnParticles(this, random);
    }

    @Override
    public void onChange() {
        super.onChange();
        WirePropogator.propogateTo(this, 0);
    }

    public boolean canConnectRedstone(int n) {
        return (n & 6) != (this.side() & 6);
    }

    public int getFace() {
        return this.side();
    }

    public int strongPowerLevel(int n) {
        return 0;
    }

    public int weakPowerLevel(int n) {
        if ((n & 6) == (this.side() & 6)) {
            return 0;
        }
        return this.rsLevel(this.getRedwireSignal(Rotation.rotationTo((int)this.side(), (int)n)));
    }

    public int rsLevel(int n) {
        if (WirePropogator.redwiresProvidePower) {
            return (n + 16) / 17;
        }
        return 0;
    }

    @Override
    public boolean isWireSide(int n) {
        return n >= 0;
    }

    @Override
    public Cuboid6 getBounds() {
        return ArrayCommons.cBoxes[this.side()];
    }

    @Override
    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(ArrayCommons.oBoxes[this.side()]);
    }

    @Override
    public void rotate() {
        int n = this.rotation();
        this.setRotation((n + 1) % 4);
        boolean bl = this.tile().canReplacePart((TMultiPart)this, (TMultiPart)this);
        this.setRotation(n);
        if (bl) {
            super.rotate();
        }
    }

    @Override
    public void preparePlacement(uf uf2, BlockCoord blockCoord, int n, int n2) {
        TMultiPart tMultiPart;
        TileMultipart tileMultipart;
        super.preparePlacement(uf2, blockCoord, n, n2);
        if (this.getLogic().canCross() && (tileMultipart = BasicUtils.getMultipartTile((acf)uf2.q, (BlockCoord)blockCoord)) != null && (tMultiPart = tileMultipart.partMap(this.side() ^ 1)) instanceof ArrayGatePart) {
            ArrayGatePart arrayGatePart = (ArrayGatePart)tMultiPart;
            if (arrayGatePart.subID == this.subID && (arrayGatePart.rotation() & 1) == (this.rotation() & 1)) {
                this.setRotation((this.rotation() + 1) % 4);
            }
        }
    }

    @Override
    public boolean occlusionTest(TMultiPart tMultiPart) {
        if (this.getLogic().canCross() && tMultiPart instanceof ArrayGatePart) {
            ArrayGatePart arrayGatePart = (ArrayGatePart)tMultiPart;
            if (arrayGatePart.subID == this.subID && arrayGatePart.side() == (this.side() ^ 1) && (arrayGatePart.rotation() & 1) != (this.rotation() & 1)) {
                return true;
            }
        }
        return super.occlusionTest(tMultiPart);
    }
}

