/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.gates.IAction;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.core.IMachine;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.utils.BlockUtil;
import buildcraft.core.utils.Utils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileMiningWell
extends TileBuildCraft
implements IMachine,
IPowerReceptor {
    boolean isDigging = true;
    private PowerHandler powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);

    public TileMiningWell() {
        float mj = 64.0f * BuildCraftFactory.miningMultiplier;
        this.powerHandler.configure(100.0f * BuildCraftFactory.miningMultiplier, 100.0f * BuildCraftFactory.miningMultiplier, mj, 1000.0f * BuildCraftFactory.miningMultiplier);
        this.powerHandler.configurePowerPerdition(1, 1);
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        float mj = 64.0f * BuildCraftFactory.miningMultiplier;
        if (this.powerHandler.useEnergy(mj, mj, true) != mj) {
            return;
        }
        World world = this.field_70331_k;
        int depth = this.field_70330_m - 1;
        while (world.func_72798_a(this.field_70329_l, depth, this.field_70327_n) == BuildCraftFactory.plainPipeBlock.field_71990_ca) {
            --depth;
        }
        if (depth < 1 || depth < this.field_70330_m - BuildCraftFactory.miningDepth || !BlockUtil.canChangeBlock(world, this.field_70329_l, depth, this.field_70327_n)) {
            this.isDigging = false;
            return;
        }
        boolean wasAir = world.func_72799_c(this.field_70329_l, depth, this.field_70327_n);
        List<ItemStack> stacks = BlockUtil.getItemStackFromBlock(this.field_70331_k, this.field_70329_l, depth, this.field_70327_n);
        world.func_94575_c(this.field_70329_l, depth, this.field_70327_n, BuildCraftFactory.plainPipeBlock.field_71990_ca);
        if (wasAir) {
            return;
        }
        if (stacks == null || stacks.isEmpty()) {
            return;
        }
        for (ItemStack stack : stacks) {
            stack.field_77994_a -= Utils.addToRandomInventoryAround(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, stack);
            if (stack.field_77994_a <= 0) continue;
            stack.field_77994_a -= Utils.addToRandomPipeAround(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, ForgeDirection.UNKNOWN, stack);
            if (stack.field_77994_a <= 0) continue;
            float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(world, (double)((float)this.field_70329_l + f), (double)((float)this.field_70330_m + f1 + 0.5f), (double)((float)this.field_70327_n + f2), stack);
            entityitem.lifespan = BuildCraftCore.itemLifespan;
            entityitem.field_70293_c = 10;
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 1.0f;
            entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
            world.func_72838_d((Entity)entityitem);
        }
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        if (this.field_70331_k != null && this.field_70330_m > 2) {
            BuildCraftFactory.miningWellBlock.removePipes(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    public boolean isActive() {
        return this.isDigging;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public boolean manageFluids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    @Override
    public boolean allowAction(IAction action) {
        return false;
    }
}

