/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.recipes;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraftforge.fluids.FluidStack;

public final class RefineryRecipes {
    private static SortedSet<Recipe> recipes = new TreeSet<Recipe>();

    public static void addRecipe(FluidStack ingredient, FluidStack result, int energy, int delay) {
        RefineryRecipes.addRecipe(ingredient, null, result, energy, delay);
    }

    public static void addRecipe(FluidStack ingredient1, FluidStack ingredient2, FluidStack result, int energy, int delay) {
        Recipe recipe = new Recipe(ingredient1, ingredient2, result, energy, delay);
        recipes.add(recipe);
    }

    public static SortedSet<Recipe> getRecipes() {
        return Collections.unmodifiableSortedSet(recipes);
    }

    public static Recipe findRefineryRecipe(FluidStack liquid1, FluidStack liquid2) {
        for (Recipe recipe : recipes) {
            if (!recipe.matches(liquid1, liquid2)) continue;
            return recipe;
        }
        return null;
    }

    private RefineryRecipes() {
    }

    public static final class Recipe
    implements Comparable<Recipe> {
        public final FluidStack ingredient1;
        public final FluidStack ingredient2;
        public final FluidStack result;
        public final int energy;
        public final int delay;

        private Recipe(FluidStack ingredient1, FluidStack ingredient2, FluidStack result, int energy, int delay) {
            if (ingredient1 == null) {
                throw new IllegalArgumentException("First Ingredient cannot be null!");
            }
            this.ingredient1 = ingredient1;
            this.ingredient2 = ingredient2;
            this.result = result;
            this.energy = energy;
            this.delay = delay;
        }

        public boolean matches(FluidStack liquid1, FluidStack liquid2) {
            if (liquid1 == null && liquid2 == null) {
                return false;
            }
            if (this.ingredient1 != null && this.ingredient2 != null && (liquid1 == null || liquid2 == null)) {
                return false;
            }
            if (liquid1 != null && liquid2 != null) {
                if (liquid1.containsFluid(this.ingredient1) && liquid1.containsFluid(this.ingredient2)) {
                    return true;
                }
                if (liquid1.containsFluid(this.ingredient2) && liquid1.containsFluid(this.ingredient1)) {
                    return true;
                }
            }
            if (liquid1 != null) {
                return liquid1.containsFluid(this.ingredient1) || liquid1.containsFluid(this.ingredient2);
            }
            if (liquid2 != null) {
                return liquid2.containsFluid(this.ingredient1) || liquid2.containsFluid(this.ingredient2);
            }
            return false;
        }

        @Override
        public int compareTo(Recipe other) {
            if (other == null) {
                return -1;
            }
            if (this.ingredient1.getFluid() != other.ingredient1.getFluid()) {
                return this.ingredient1.getFluid().getName().compareTo(other.ingredient1.getFluid().getName());
            }
            if (this.ingredient1.amount != other.ingredient1.amount) {
                return other.ingredient1.amount - this.ingredient1.amount;
            }
            if (this.ingredient2 == null) {
                return other.ingredient2 == null ? 0 : 1;
            }
            if (other.ingredient2 == null) {
                return -1;
            }
            if (this.ingredient2.getFluid() != other.ingredient2.getFluid()) {
                return this.ingredient2.getFluid().getName().compareTo(other.ingredient2.getFluid().getName());
            }
            if (this.ingredient2.amount != other.ingredient2.amount) {
                return other.ingredient2.amount - this.ingredient2.amount;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof Recipe && Objects.equal((Object)this.ingredient1, (Object)((Recipe)obj).ingredient1) && Objects.equal((Object)this.ingredient2, (Object)((Recipe)obj).ingredient2);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.ingredient1, this.ingredient2});
        }
    }
}

