/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.treecapitator.TCSettings;
import bspkrs.treecapitator.ToolRegistry;
import bspkrs.treecapitator.TreeRegistry;

public class RegistryNBTManager {
    private by localTCSettings;
    private by localTreeRegistry;
    private by localToolRegistry;
    private by remoteTCSettings;
    private by remoteTreeRegistry;
    private by remoteToolRegistry;

    public RegistryNBTManager(by tcSettingsNBT, by treeRegistryNBT, by toolRegistryNBT) {
        this();
        this.setRemoteTCSettings(tcSettingsNBT);
        this.setRemoteTreeRegistry(treeRegistryNBT);
        this.setRemoteToolRegistry(toolRegistryNBT);
    }

    public RegistryNBTManager() {
        this.saveCurrentTCSettingsToLocal();
        this.saveCurrentTreeRegistryToLocal();
        this.saveCurrentToolRegistryToLocal();
        this.setRemoteTCSettings(this.localTCSettings);
        this.setRemoteTreeRegistry(this.localTreeRegistry);
        this.setRemoteToolRegistry(this.localToolRegistry);
    }

    protected RegistryNBTManager saveCurrentTCSettingsToLocal() {
        this.localTCSettings = new by();
        TCSettings.instance().writeToNBT(this.localTCSettings);
        return this;
    }

    protected RegistryNBTManager saveCurrentTreeRegistryToLocal() {
        this.localTreeRegistry = new by();
        TreeRegistry.instance().writeToNBT(this.localTreeRegistry);
        return this;
    }

    protected RegistryNBTManager saveCurrentToolRegistryToLocal() {
        this.localToolRegistry = new by();
        ToolRegistry.instance().writeToNBT(this.localToolRegistry);
        return this;
    }

    public RegistryNBTManager setRemoteTCSettings(by ntc) {
        this.remoteTCSettings = ntc;
        return this;
    }

    public RegistryNBTManager setRemoteTreeRegistry(by ntc) {
        this.remoteTreeRegistry = ntc;
        return this;
    }

    public RegistryNBTManager setRemoteToolRegistry(by ntc) {
        this.remoteToolRegistry = ntc;
        return this;
    }

    public RegistryNBTManager setRemoteNBTs(by set, by tree, by tool) {
        return this.setRemoteTCSettings(set).setRemoteTreeRegistry(tree).setRemoteToolRegistry(tool);
    }

    public void registerLocalInstances() {
        TCSettings.instance().readFromNBT(this.localTCSettings);
        TreeRegistry.instance().readFromNBT(this.localTreeRegistry);
        ToolRegistry.instance().readFromNBT(this.localToolRegistry);
    }

    public void registerRemoteInstances() {
        TCSettings.instance().readFromNBT(this.remoteTCSettings);
        TreeRegistry.instance().readFromNBT(this.remoteTreeRegistry);
        ToolRegistry.instance().readFromNBT(this.remoteToolRegistry);
    }

    public Object[] getPacketArray() {
        return new Object[]{this.localTCSettings, this.localTreeRegistry, this.localToolRegistry};
    }
}

