/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.registry.EntityRegistry;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IArmorNaturalist;
import forestry.api.core.ITileStructure;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.core.config.Config;
import forestry.core.gadgets.TileForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Vect;
import forestry.plugins.PluginArboriculture;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class Utils {
    private static EntityPlayer modPlayer;
    private static Random rand;
    private static final String HEX = "0123456789abcdef";

    public static EntityPlayer getForestryPlayer(World world, int x, int y, int z) {
        if (modPlayer == null) {
            modPlayer = new EntityPlayer(world, Config.fakeUserLogin){

                public void func_70006_a(ChatMessageComponent message) {
                }

                public boolean func_70003_b(int var1, String var2) {
                    return false;
                }

                public ChunkCoordinates func_82114_b() {
                    return null;
                }
            };
            Utils.modPlayer.field_70165_t = x;
            Utils.modPlayer.field_70163_u = y;
            Utils.modPlayer.field_70161_v = z;
            Proxies.log.info("Created player '%s' for Forestry.", (Object)Utils.modPlayer.field_71092_bJ);
            if (Config.fakeUserAutoop) {
                MinecraftServer.func_71196_a((MinecraftServer)MinecraftServer.func_71276_C()).func_72386_b(Utils.modPlayer.field_71092_bJ);
                Proxies.log.info("Opped player '%s'.", (Object)Utils.modPlayer.field_71092_bJ);
            }
        }
        return modPlayer;
    }

    public static int getUID() {
        if (rand == null) {
            rand = new Random();
        }
        int uid = rand.nextInt();
        return uid;
    }

    public static void dropInventory(TileForestry tile, World world, int x, int y, int z) {
        block7: {
            block6: {
                if (tile == null) {
                    return;
                }
                if (!(tile instanceof ITileStructure)) break block6;
                IInventory inventory = ((ITileStructure)((Object)tile)).getInventory();
                if (inventory == null) break block7;
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    if (inventory.func_70301_a(i) == null) continue;
                    StackUtils.dropItemStackAsEntity(inventory.func_70301_a(i), world, x, y, z);
                    inventory.func_70299_a(i, null);
                }
                break block7;
            }
            Object inventory = tile instanceof IInventory ? (IInventory)tile : tile.getInternalInventory();
            if (inventory != null) {
                for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
                    ItemStack itemstack = inventory.func_70301_a(slot);
                    if (itemstack == null) continue;
                    float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    while (itemstack.field_77994_a > 0) {
                        int stackPartial = world.field_73012_v.nextInt(21) + 10;
                        if (stackPartial > itemstack.field_77994_a) {
                            stackPartial = itemstack.field_77994_a;
                        }
                        ItemStack drop = itemstack.func_77979_a(stackPartial);
                        EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), drop);
                        float accel = 0.05f;
                        entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * accel;
                        entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * accel + 0.2f;
                        entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * accel;
                        world.func_72838_d((Entity)entityitem);
                    }
                    inventory.func_70299_a(slot, null);
                }
            }
        }
    }

    public static boolean hasNaturalistEye(EntityPlayer player) {
        ItemStack armorItem = player.field_71071_by.field_70460_b[3];
        return armorItem != null && armorItem.func_77973_b() instanceof IArmorNaturalist && ((IArmorNaturalist)armorItem.func_77973_b()).canSeePollination(player, armorItem, true);
    }

    public static void broadcastMessage(World world, String message) {
        for (EntityPlayer entityplayer : world.field_73010_i) {
            entityplayer.func_71035_c(message);
        }
    }

    public static IInventory getChest(IInventory inventory) {
        Vect[] adjacent;
        if (!(inventory instanceof TileEntityChest)) {
            return inventory;
        }
        TileEntityChest chest = (TileEntityChest)inventory;
        for (Vect pos : adjacent = new Vect[]{new Vect(chest.field_70329_l + 1, chest.field_70330_m, chest.field_70327_n), new Vect(chest.field_70329_l - 1, chest.field_70330_m, chest.field_70327_n), new Vect(chest.field_70329_l, chest.field_70330_m, chest.field_70327_n + 1), new Vect(chest.field_70329_l, chest.field_70330_m, chest.field_70327_n - 1)}) {
            TileEntity otherchest = chest.field_70331_k.func_72796_p(pos.x, pos.y, pos.z);
            if (!(otherchest instanceof TileEntityChest)) continue;
            return new InventoryLargeChest("", (IInventory)chest, (IInventory)((TileEntityChest)otherchest));
        }
        return inventory;
    }

    public static Object[] concat(Object[] first, Object[] second) {
        Object[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static int[] concat(int[] first, int[] second) {
        int[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static short[] concat(short[] first, short[] second) {
        short[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static float[] concat(float[] first, float[] second) {
        float[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static boolean canWrench(EntityPlayer player, int x, int y, int z) {
        ItemStack itemstack = player.func_71045_bC();
        if (itemstack == null) {
            return false;
        }
        if (!(itemstack.func_77973_b() instanceof IToolWrench)) {
            return false;
        }
        IToolWrench wrench = (IToolWrench)itemstack.func_77973_b();
        return wrench.canWrench(player, x, y, z);
    }

    public static void useWrench(EntityPlayer player, int x, int y, int z) {
        ItemStack itemstack = player.func_71045_bC();
        if (itemstack == null) {
            return;
        }
        if (!(itemstack.func_77973_b() instanceof IToolWrench)) {
            return;
        }
        ((IToolWrench)itemstack.func_77973_b()).wrenchUsed(player, x, y, z);
    }

    public static EnumTankLevel rateTankLevel(int scaled) {
        if (scaled < 5) {
            return EnumTankLevel.EMPTY;
        }
        if (scaled < 30) {
            return EnumTankLevel.LOW;
        }
        if (scaled < 60) {
            return EnumTankLevel.MEDIUM;
        }
        if (scaled < 90) {
            return EnumTankLevel.HIGH;
        }
        return EnumTankLevel.MAXIMUM;
    }

    public static boolean isReplaceableBlock(World world, int x, int y, int z) {
        int blockid = world.func_72798_a(x, y, z);
        return blockid == Block.field_71998_bu.field_71990_ca || blockid == Block.field_71962_X.field_71990_ca || blockid == Block.field_71961_Y.field_71990_ca || blockid == Block.field_72037_aS.field_71990_ca || Block.field_71973_m[blockid] != null && Block.field_71973_m[blockid].isBlockReplaceable(world, x, y, z);
    }

    public static boolean isLiquidBlock(World world, int x, int y, int z) {
        return Utils.isLiquidBlock(world.func_72798_a(x, y, z));
    }

    public static boolean isLiquidBlock(int blockid) {
        return blockid == Block.field_71943_B.field_71990_ca || blockid == Block.field_71942_A.field_71990_ca || blockid == Block.field_71938_D.field_71990_ca || blockid == Block.field_71944_C.field_71990_ca;
    }

    public static boolean isUseableByPlayer(EntityPlayer player, TileEntity tile, World world, int x, int y, int z) {
        if (world.func_72796_p(x, y, z) != tile) {
            return false;
        }
        return player.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) <= 64.0;
    }

    public static BiomeGenBase getBiomeAt(World world, int x, int z) {
        return world.getBiomeGenForCoordsBody(x, z);
    }

    public static Entity spawnEntity(World world, Class entityClass, double x, double y, double z) {
        if (!EntityList.field_75626_c.containsKey(entityClass)) {
            return null;
        }
        return Utils.spawnEntity(world, EntityList.func_75620_a((String)((String)EntityList.field_75626_c.get(entityClass)), (World)world), x, y, z);
    }

    public static Entity spawnEntity(World world, Entity spawn, double x, double y, double z) {
        if (spawn != null && spawn instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)spawn;
            spawn.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            living.field_70759_as = living.field_70177_z;
            living.field_70761_aq = living.field_70177_z;
            living.func_110161_a((EntityLivingData)null);
            world.func_72838_d(spawn);
            living.func_70642_aH();
        }
        return spawn;
    }

    public static void registerEntity(Class entityClass, String ident, int id, int eggForeground, int eggBackground, int trackingRange, int updateFrequency, boolean sendVelocity) {
        EntityRegistry.registerModEntity((Class)entityClass, (String)ident, (int)id, (Object)ForestryAPI.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendVelocity);
        Proxies.log.finer("Registered entity %s (%s) with id %s.", ident, entityClass.toString(), id);
    }

    public static int addRGBComponents(int colour, int r, int g, int b) {
        r = ((colour & 0xFF0000) >> 16) + r;
        g = ((colour & 0xFF00) >> 8) + b;
        b = (colour & 0xFF) + b;
        r = r <= 255 ? r : 255;
        g = g <= 255 ? g : 255;
        b = b <= 255 ? b : 255;
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int multiplyRGBComponents(int colour, float factor) {
        int r = (int)((float)((colour & 0xFF0000) >> 16) * factor);
        int g = (int)((float)((colour & 0xFF00) >> 8) * factor);
        int b = (int)((float)(colour & 0xFF) * factor);
        r = r <= 255 ? r : 255;
        g = g <= 255 ? g : 255;
        b = b <= 255 ? b : 255;
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static String getFingerprint(Certificate certificate) {
        if (certificate == null) {
            return "Certificate invalid";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] der = certificate.getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            return Utils.tohex(digest);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String tohex(byte[] checksum) {
        StringBuilder hex = new StringBuilder(2 * checksum.length);
        for (byte bty : checksum) {
            hex.append(HEX.charAt((bty & 0xF0) >> 4)).append(HEX.charAt(bty & 0xF));
        }
        return hex.toString();
    }

    public static ItemStack convertSaplingToGeneticEquivalent(ItemStack foreign) {
        ItemStack ersatz = null;
        ITree tree = null;
        for (Map.Entry entry : AlleleManager.ersatzSaplings.entrySet()) {
            if (((ItemStack)entry.getKey()).field_77993_c != foreign.field_77993_c || ((ItemStack)entry.getKey()).func_77960_j() != foreign.func_77960_j()) continue;
            if (entry.getValue() instanceof ITree) {
                tree = (ITree)entry.getValue();
            }
            ersatz = PluginArboriculture.treeInterface.getMemberStack(tree, EnumGermlingType.SAPLING.ordinal());
            ersatz.field_77994_a = foreign.field_77994_a;
        }
        return ersatz;
    }

    public static IPollinatable getOrCreatePollinatable(String owner, World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        IPollinatable receiver = null;
        if (tile instanceof IPollinatable) {
            receiver = (IPollinatable)tile;
        } else if (!world.func_72799_c(x, y, z)) {
            for (Map.Entry entry : AlleleManager.ersatzSpecimen.entrySet()) {
                if (((ItemStack)entry.getKey()).field_77993_c != world.func_72798_a(x, y, z)) continue;
                int meta = world.func_72805_g(x, y, z);
                if (((ItemStack)entry.getKey()).field_77993_c == Block.field_71952_K.field_71990_ca) {
                    meta &= 3;
                }
                if (((ItemStack)entry.getKey()).func_77960_j() != meta) continue;
                PluginArboriculture.treeInterface.setLeaves(world, (IIndividual)entry.getValue(), owner, x, y, z);
                receiver = (IPollinatable)world.func_72796_p(x, y, z);
            }
        }
        return receiver;
    }
}

