/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.widgets;

import forestry.core.circuits.ISolderingIron;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.gui.ContainerSocketed;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.WidgetManager;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.interfaces.ISocketable;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SocketWidget
extends Widget {
    ISocketable tile;
    int slot = 0;
    protected final ToolTip toolTip = new ToolTip(500){

        @Override
        public void refresh() {
            SocketWidget.this.toolTip.clear();
            ItemStack stack = SocketWidget.this.tile.getSocket(SocketWidget.this.slot);
            if (stack != null) {
                for (String line : stack.func_82840_a((EntityPlayer)Proxies.common.getClientInstance().field_71439_g, false)) {
                    SocketWidget.this.toolTip.add(line);
                }
            } else {
                SocketWidget.this.toolTip.add(StringUtil.localize("gui.emptysocket"));
            }
        }
    };

    public SocketWidget(WidgetManager manager, int xPos, int yPos, ISocketable tile, int slot) {
        super(manager, xPos, yPos);
        this.tile = tile;
        this.slot = slot;
    }

    @Override
    public void draw(int startX, int startY) {
        ItemStack socketStack = this.tile.getSocket(this.slot);
        if (socketStack != null) {
            GuiForestry.getItemRenderer().func_77015_a(this.manager.minecraft.field_71466_p, this.manager.minecraft.field_71446_o, socketStack, startX + this.xPos, startY + this.yPos);
        }
    }

    @Override
    public ToolTip getToolTip() {
        return this.toolTip;
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        ItemStack itemstack = this.manager.minecraft.field_71439_g.field_71071_by.func_70445_o();
        if (itemstack == null) {
            return;
        }
        Item held = itemstack.func_77973_b();
        if (held instanceof ItemCircuitBoard) {
            ((ContainerSocketed)this.manager.gui.field_74193_d).handleChipsetClick(this.slot, (EntityPlayer)this.manager.minecraft.field_71439_g, itemstack);
        } else if (held instanceof ISolderingIron) {
            ((ContainerSocketed)this.manager.gui.field_74193_d).handleSolderingIronClick(this.slot, (EntityPlayer)this.manager.minecraft.field_71439_g, itemstack);
        }
    }
}

