/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.GuiForestry;
import forestry.core.gui.widgets.Widget;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class WidgetManager {
    public GuiForestry gui;
    public Minecraft minecraft;
    protected ArrayList widgets = new ArrayList();

    public WidgetManager(GuiForestry gui) {
        this.gui = gui;
        this.minecraft = Proxies.common.getClientInstance();
    }

    public void add(Widget slot) {
        this.widgets.add(slot);
    }

    public void remove(Widget slot) {
        this.widgets.remove(slot);
    }

    public void clear() {
        this.widgets.clear();
    }

    protected Widget getAtPosition(int mX, int mY) {
        for (Widget slot : this.widgets) {
            if (!slot.isMouseOver(mX, mY)) continue;
            return slot;
        }
        return null;
    }

    public void drawWidgets() {
        this.gui.setZLevel(100.0f);
        GuiForestry.getItemRenderer().field_77023_b = 100.0f;
        for (Widget slot : this.widgets) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            slot.draw(0, 0);
        }
        this.gui.setZLevel(0.0f);
        GuiForestry.getItemRenderer().field_77023_b = 0.0f;
    }

    public void handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        Widget slot = this.getAtPosition(mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTop());
        if (slot != null) {
            slot.handleMouseClick(mouseX, mouseY, mouseButton);
        }
    }

    public void handleMouseRelease(int mouseX, int mouseY, int eventType) {
        for (Widget slot : this.widgets) {
            slot.handleMouseRelease(mouseX, mouseY, eventType);
        }
    }

    public void handleMouseMove(int mouseX, int mouseY, int mouseButton, long time) {
        for (Widget slot : this.widgets) {
            slot.handleMouseMove(mouseX, mouseY, mouseButton, time);
        }
    }
}

