/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.core.EnumErrorCode;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.network.PacketInventoryStack;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ForestryTank;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileAnalyzer
extends TileBase
implements ISpecialInventory,
ISidedInventory,
ILiquidTankContainer {
    public static final int TIME_TO_ANALYZE = 500;
    public static final int HONEY_REQUIRED = 100;
    public static final short SLOT_ANALYZE = 0;
    public static final short SLOT_CAN = 1;
    public static final short SLOT_INPUT_1 = 2;
    public static final short SLOT_OUTPUT_1 = 8;
    private InventoryAdapter inventory = new InventoryAdapter(12, "Items");
    private int analyzeTime;
    private short analyzeSlot = 0;
    private short canSlot = 1;
    private short inputSlot1 = (short)2;
    private short outputSlot1 = (short)8;
    public FluidStack resource = FluidRegistry.getFluidStack((String)"honey", (int)100);
    @EntityNetData
    public ForestryTank resourceTank = new ForestryTank(10000);
    private Stack pendingProducts = new Stack();

    @Override
    public String func_70303_b() {
        return StringUtil.localize("core.0");
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.AnalyzerGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("AnalyzeTime", this.analyzeTime);
        this.resourceTank.writeToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] pending = this.pendingProducts.toArray(new ItemStack[this.pendingProducts.size()]);
        for (int i = 0; i < pending.length; ++i) {
            if (pending[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            pending[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingProducts", (NBTBase)nbttaglist);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.analyzeTime = nbttagcompound.func_74762_e("AnalyzeTime");
        this.resourceTank.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("PendingProducts");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            this.pendingProducts.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void updateServerSide() {
        FluidContainerRegistry.FluidContainerData container;
        if (this.tryAddPending()) {
            return;
        }
        if (!this.pendingProducts.isEmpty()) {
            this.setErrorState(EnumErrorCode.NOSPACE);
            return;
        }
        if (this.func_70301_a(this.canSlot) != null && (container = LiquidHelper.getLiquidContainer(this.func_70301_a(this.canSlot))) != null && this.resource.isFluidEqual(container.fluid)) {
            this.func_70299_a(this.canSlot, StackUtils.replenishByContainer(this, this.func_70301_a(this.canSlot), container, this.resourceTank));
            if (this.func_70301_a((int)this.canSlot).field_77994_a <= 0) {
                this.func_70299_a(this.canSlot, null);
            }
        }
        if (this.analyzeTime > 0 && this.func_70301_a(this.analyzeSlot) != null && AlleleManager.alleleRegistry.isIndividual(this.func_70301_a(this.analyzeSlot))) {
            --this.analyzeTime;
            if (this.analyzeTime > 0) {
                this.setErrorState(EnumErrorCode.OK);
                return;
            }
            IIndividual individual = AlleleManager.alleleRegistry.getIndividual(this.func_70301_a(this.analyzeSlot));
            if (individual == null) {
                return;
            }
            individual.analyze();
            NBTTagCompound nbttagcompound = new NBTTagCompound("tag");
            individual.writeToNBT(nbttagcompound);
            this.func_70301_a(this.analyzeSlot).func_77982_d(nbttagcompound);
            this.pendingProducts.push(this.func_70301_a(this.analyzeSlot));
            this.func_70299_a(this.analyzeSlot, null);
            this.sendNetworkUpdate();
        } else {
            this.analyzeTime = 0;
            if (this.func_70301_a(this.analyzeSlot) != null) {
                return;
            }
            if (this.resourceTank.getFluidAmount() < this.resource.amount) {
                this.setErrorState(EnumErrorCode.NORESOURCE);
                return;
            }
            for (int i = this.inputSlot1; i < this.outputSlot1; ++i) {
                if (this.func_70301_a(i) == null || !AlleleManager.alleleRegistry.isIndividual(this.func_70301_a(i))) continue;
                IIndividual individual = AlleleManager.alleleRegistry.getIndividual(this.func_70301_a(i));
                if (individual.isAnalyzed()) {
                    this.pendingProducts.push(this.func_70301_a(i));
                    this.func_70299_a(i, null);
                    continue;
                }
                this.func_70299_a(this.analyzeSlot, this.func_70301_a(i));
                this.func_70299_a(i, null);
                this.resourceTank.drain(this.resource.amount, true);
                this.analyzeTime = 500;
                this.sendNetworkUpdate();
                return;
            }
            this.setErrorState(EnumErrorCode.NOTHINGANALYZE);
        }
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        ItemStack next = (ItemStack)this.pendingProducts.peek();
        if (this.inventory.tryAddStack(next, this.outputSlot1, this.inventory.func_70302_i_() - this.outputSlot1, true)) {
            this.pendingProducts.pop();
            return true;
        }
        return false;
    }

    public boolean isWorking() {
        return this.analyzeTime > 0;
    }

    public int getProgressScaled(int i) {
        return this.analyzeTime * i / 500;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    public ItemStack getIndividualOnDisplay() {
        return this.func_70301_a(this.analyzeSlot);
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.analyzeTime = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.analyzeTime);
    }

    @Override
    public void sendNetworkUpdate() {
        Proxies.net.sendNetworkPacket(new PacketInventoryStack(3, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, this.inventory.func_70301_a(0)), this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public Packet func_70319_e() {
        return new PacketInventoryStack(3, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, this.inventory.func_70301_a(0)).getPacket();
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex >= 8 && slotIndex < 12;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex >= 2 && slotIndex < 8) {
            return AlleleManager.alleleRegistry.isIndividual(itemstack);
        }
        if (slotIndex == 1) {
            FluidContainerRegistry.FluidContainerData container = LiquidHelper.getLiquidContainer(itemstack);
            return container != null && LiquidHelper.isLiquid("honey", container.fluid);
        }
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ItemStack product = null;
        for (int i = this.outputSlot1; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.func_70301_a(i) == null) continue;
            product = this.func_70301_a(i).func_77946_l();
            if (!doRemove) break;
            this.func_70301_a((int)i).field_77994_a = 0;
            this.func_70299_a(i, null);
            break;
        }
        return new ItemStack[]{product};
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (!AlleleManager.alleleRegistry.isIndividual(stack)) {
            FluidContainerRegistry.FluidContainerData container = LiquidHelper.getLiquidContainer(stack);
            if (container == null || !container.fluid.isFluidEqual(this.resource)) {
                return 0;
            }
            if (this.func_70301_a(this.canSlot) == null) {
                if (doAdd) {
                    this.func_70299_a(this.canSlot, stack.func_77946_l());
                }
                return stack.field_77994_a;
            }
            int space = this.func_70301_a(this.canSlot).func_77976_d() - this.func_70301_a((int)this.canSlot).field_77994_a;
            if (space <= 0) {
                return 0;
            }
            if (doAdd) {
                this.func_70301_a((int)this.canSlot).field_77994_a += stack.field_77994_a;
                if (this.func_70301_a((int)this.canSlot).field_77994_a > this.func_70301_a(this.canSlot).func_77976_d()) {
                    this.func_70301_a((int)this.canSlot).field_77994_a = this.func_70301_a(this.canSlot).func_77976_d();
                }
            }
            return space;
        }
        for (int i = this.inputSlot1; i < this.outputSlot1; ++i) {
            if (this.func_70301_a(i) != null) continue;
            if (doAdd) {
                this.func_70299_a(i, stack.func_77946_l());
            }
            return stack.field_77994_a;
        }
        return 0;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.resourceTank.getFluidAmount() > 0 && !this.resourceTank.getFluid().isFluidEqual(resource)) {
            return 0;
        }
        if (!LiquidHelper.isLiquid("honey", resource)) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public ForestryTank[] getTanks() {
        return new ForestryTank[]{this.resourceTank};
    }
}

