/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.apiculture.genetics.BeeGenome;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.core.EnumErrorCode;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.ClimateHelper;
import forestry.core.genetics.GenericRatings;
import forestry.core.genetics.IndividualLiving;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.plugins.PluginApiculture;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class Bee
extends IndividualLiving
implements IBee {
    public IBeeGenome genome;
    public IBeeGenome mate;

    public Bee(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    public Bee(World world, IBeeGenome genome, IBee mate) {
        this(world, genome);
        this.mate = mate.getGenome();
        this.isIrregularMating = mate.isNatural() != this.isNatural;
    }

    public Bee(IBeeGenome genome, IBee mate) {
        this(genome);
        this.mate = mate.getGenome();
        this.isIrregularMating = mate.isNatural() != this.isNatural;
    }

    public Bee(World world, IBeeGenome genome) {
        this(world, genome, true, 0);
    }

    public Bee(IBeeGenome genome) {
        this(genome, true, 0);
    }

    public Bee(World world, IBeeGenome genome, boolean isNatural, int generation) {
        super(genome.getLifespan(), isNatural, generation);
        this.genome = genome;
    }

    public Bee(IBeeGenome genome, boolean isNatural, int generation) {
        super(genome.getLifespan(), isNatural, generation);
        this.genome = genome;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound == null) {
            this.genome = PluginApiculture.beeInterface.templateAsGenome(BeeTemplates.getForestTemplate());
            return;
        }
        super.readFromNBT(nbttagcompound);
        this.genome = nbttagcompound.func_74764_b("Genome") ? new BeeGenome(nbttagcompound.func_74775_l("Genome")) : PluginApiculture.beeInterface.templateAsGenome(BeeTemplates.getForestTemplate());
        if (nbttagcompound.func_74764_b("Mate")) {
            this.mate = new BeeGenome(nbttagcompound.func_74775_l("Mate"));
        }
    }

    @Override
    public void mate(IIndividual individual) {
        if (!(individual instanceof IBee)) {
            return;
        }
        IBee drone = (IBee)individual;
        this.mate = drone.getGenome();
        this.isIrregularMating = drone.isNatural() != this.isNatural;
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, IBeeHousing housing) {
        IAlleleBeeEffect effect = this.genome.getEffect();
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doEffect(effect, storedData[0], housing);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleBeeEffect secondary = (IAlleleBeeEffect)this.genome.getInactiveAllele(EnumBeeChromosome.EFFECT.ordinal());
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doEffect(secondary, storedData[1], housing);
        return storedData;
    }

    private IEffectData doEffect(IAlleleBeeEffect effect, IEffectData storedData, IBeeHousing housing) {
        storedData = effect.validateStorage(storedData);
        return effect.doEffect(this.genome, storedData, housing);
    }

    @Override
    public IEffectData[] doFX(IEffectData[] storedData, IBeeHousing housing) {
        IAlleleBeeEffect effect = this.genome.getEffect();
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doFX(effect, storedData[0], housing);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleBeeEffect secondary = (IAlleleBeeEffect)this.genome.getInactiveAllele(EnumBeeChromosome.EFFECT.ordinal());
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doFX(secondary, storedData[1], housing);
        return storedData;
    }

    private IEffectData doFX(IAlleleBeeEffect effect, IEffectData storedData, IBeeHousing housing) {
        return effect.doFX(this.genome, storedData, housing);
    }

    @Override
    public IBeeGenome getGenome() {
        return this.genome;
    }

    @Override
    public IBeeGenome getMate() {
        return this.mate;
    }

    @Override
    public IBee copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Bee(nbttagcompound);
    }

    @Override
    public boolean canSpawn() {
        return this.mate != null;
    }

    @Override
    public int isWorking(IBeeHousing housing) {
        BiomeGenBase biome;
        World world = housing.getWorld();
        if (world.func_72896_J() && !this.genome.getTolerantFlyer() && housing.getHumidity() != EnumHumidity.ARID && !housing.isSealed()) {
            return EnumErrorCode.ISRAINING.ordinal();
        }
        if (world.func_72935_r()) {
            if (!this.canWorkDuringDay()) {
                return EnumErrorCode.NOTNIGHT.ordinal();
            }
        } else if (!this.canWorkAtNight() && !housing.isSelfLighted()) {
            return EnumErrorCode.NOTDAY.ordinal();
        }
        if (world.func_72957_l(housing.getXCoord(), housing.getYCoord() + 2, housing.getZCoord()) > 11) {
            if (!this.canWorkDuringDay()) {
                return EnumErrorCode.NOTGLOOMY.ordinal();
            }
        } else if (!this.canWorkAtNight() && !housing.isSelfLighted()) {
            return EnumErrorCode.NOTLUCID.ordinal();
        }
        if ((biome = BiomeGenBase.field_76773_a[housing.getBiomeId()]) == null) {
            return EnumErrorCode.NOSKY.ordinal();
        }
        if (!(BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || world.func_72937_j(housing.getXCoord(), housing.getYCoord() + 3, housing.getZCoord()) || this.genome.getCaveDwelling() || housing.isSunlightSimulated())) {
            return EnumErrorCode.NOSKY.ordinal();
        }
        if (!this.checkBiomeHazard(world, housing.getTemperature(), housing.getHumidity(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord())) {
            return EnumErrorCode.INVALIDBIOME.ordinal();
        }
        return EnumErrorCode.OK.ordinal();
    }

    private boolean canWorkAtNight() {
        return this.genome.getPrimary().isNocturnal() || this.genome.getNocturnal();
    }

    private boolean canWorkDuringDay() {
        return !this.genome.getPrimary().isNocturnal() || this.genome.getNocturnal();
    }

    private boolean checkBiomeHazard(World world, EnumTemperature temperature, EnumHumidity humidity, int x, int y, int z) {
        return ClimateHelper.isWithinLimits(temperature, humidity, this.genome.getPrimary().getTemperature(), this.genome.getToleranceTemp(), this.genome.getPrimary().getHumidity(), this.genome.getToleranceHumid());
    }

    @Override
    public boolean hasFlower(IBeeHousing housing) {
        IFlowerProvider provider = this.genome.getFlowerProvider();
        Vect coords = new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord());
        Vect posCurrent = new Vect(0, 0, 0);
        int[] areaAr = this.genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]).multiply(housing.getTerritoryModifier(this.genome, 1.0f));
        if (area.x < 1) {
            area.x = 1;
        }
        if (area.y < 1) {
            area.y = 1;
        }
        if (area.z < 1) {
            area.z = 1;
        }
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        boolean hasFlower = false;
        while (this.advancePosition(posCurrent, area)) {
            Vect posBlock = posCurrent.add(coords);
            posBlock = posBlock.add(offset);
            if (!provider.isAcceptedFlower(housing.getWorld(), this, posBlock.x, posBlock.y, posBlock.z)) continue;
            hasFlower = true;
            break;
        }
        return hasFlower;
    }

    private boolean advancePosition(Vect posCurrent, Vect area) {
        if (posCurrent.z < area.z - 1) {
            ++posCurrent.z;
        } else {
            posCurrent.z = 0;
            if (posCurrent.x < area.x - 1) {
                ++posCurrent.x;
            } else {
                posCurrent.x = 0;
                if (posCurrent.y < area.y - 1) {
                    ++posCurrent.y;
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public ArrayList getSuitableBiomeIds() {
        EnumTemperature temperature = this.genome.getPrimary().getTemperature();
        EnumTolerance temperatureTolerance = this.genome.getToleranceTemp();
        ArrayList toleratedTemperatures = ClimateHelper.getToleratedTemperature(temperature, temperatureTolerance);
        EnumHumidity humidity = this.genome.getPrimary().getHumidity();
        EnumTolerance humidityTolerance = this.genome.getToleranceHumid();
        ArrayList toleratedHumidities = ClimateHelper.getToleratedHumidity(humidity, humidityTolerance);
        ArrayList biomeIdsTemp = new ArrayList();
        for (EnumTemperature temp : toleratedTemperatures) {
            biomeIdsTemp.addAll(EnumTemperature.getBiomeIds(temp));
        }
        ArrayList biomeIdsHumid = new ArrayList();
        for (EnumHumidity humid : toleratedHumidities) {
            biomeIdsHumid.addAll(EnumHumidity.getBiomeIds(humid));
        }
        biomeIdsTemp.retainAll(biomeIdsHumid);
        return biomeIdsTemp;
    }

    @Override
    public void addTooltip(List list) {
        if (!this.isAnalyzed) {
            list.add("<" + StringUtil.localize("gui.unknown") + ">");
            return;
        }
        IAlleleBeeSpecies primary = this.genome.getPrimary();
        IAlleleBeeSpecies secondary = this.genome.getSecondary();
        if (!this.isPureBred(EnumBeeChromosome.SPECIES.ordinal())) {
            list.add("\u00a79" + primary.getName() + StringUtil.localize("bees.hyphen.adj.add") + "-" + secondary.getName() + StringUtil.localize("bees.hybrid.adj.add") + " " + StringUtil.localize("gui.hybrid"));
        }
        list.add(this.genome.getActiveAllele(EnumBeeChromosome.SPEED.ordinal()).getName() + " " + StringUtil.localize("gui.worker"));
        list.add(this.genome.getActiveAllele(EnumBeeChromosome.LIFESPAN.ordinal()).getName() + " " + StringUtil.localize("gui.life"));
        list.add("\u00a7aT: " + ClimateHelper.toDisplay(this.genome.getPrimary().getTemperature()) + " / " + StringUtil.capitalize(this.genome.getToleranceTemp().name()));
        list.add("\u00a7aH: " + ClimateHelper.toDisplay(this.genome.getPrimary().getHumidity()) + " / " + StringUtil.capitalize(this.genome.getToleranceHumid().name()));
        list.add(StringUtil.localize(this.genome.getFlowerProvider().getDescription()));
        if (this.genome.getNocturnal()) {
            list.add("\u00a7c" + GenericRatings.rateActivityTime(this.genome.getNocturnal(), false));
        }
    }

    @Override
    public void age(World world, float housingLifespanModifier) {
        IBeekeepingMode mode = PluginApiculture.beeInterface.getBeekeepingMode(world);
        float finalModifier = housingLifespanModifier * mode.getLifespanModifier(this.genome, this.mate, housingLifespanModifier);
        super.age(world, finalModifier);
    }

    @Override
    public ItemStack[] getProduceList() {
        ArrayList<Object> products = new ArrayList<Object>();
        IAlleleBeeSpecies primary = this.genome.getPrimary();
        IAlleleBeeSpecies secondary = this.genome.getSecondary();
        products.addAll(primary.getProducts().keySet());
        Set secondaryProducts = secondary.getProducts().keySet();
        for (ItemStack second : secondaryProducts) {
            boolean skip = false;
            for (ItemStack itemStack : products) {
                if (!second.func_77969_a(itemStack)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            products.add(second);
        }
        return products.toArray(new ItemStack[0]);
    }

    @Override
    public ItemStack[] getSpecialtyList() {
        return this.genome.getPrimary().getSpecialty().keySet().toArray(new ItemStack[0]);
    }

    @Override
    public ItemStack[] produceStacks(IBeeHousing housing) {
        if (!this.hasFlower(housing)) {
            return null;
        }
        if (housing == null) {
            Proxies.log.warning("Failed to produce in an apiary because the beehousing was null.");
            return null;
        }
        IBeekeepingMode mode = PluginApiculture.beeInterface.getBeekeepingMode(housing.getWorld());
        if (mode == null) {
            Proxies.log.warning("Failed to produce in an apiary because the beekeeping mode was null.");
            return null;
        }
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        IAlleleBeeSpecies primary = this.genome.getPrimary();
        IAlleleBeeSpecies secondary = this.genome.getSecondary();
        if (mode.isOverworked(this, housing)) {
            this.setIsNatural(false);
        }
        float speed = this.genome.getSpeed() * housing.getProductionModifier(this.genome, 1.0f) * mode.getProductionModifier(this.genome, 1.0f);
        for (Map.Entry entry : primary.getProducts().entrySet()) {
            if (!((float)housing.getWorld().field_73012_v.nextInt(100) < (float)((Integer)entry.getValue()).intValue() * speed)) continue;
            products.add(((ItemStack)entry.getKey()).func_77946_l());
        }
        for (Map.Entry entry : secondary.getProducts().entrySet()) {
            if (!((float)housing.getWorld().field_73012_v.nextInt(100) < (float)Math.round((Integer)entry.getValue() / 2) * speed)) continue;
            products.add(((ItemStack)entry.getKey()).func_77946_l());
        }
        if (!primary.isJubilant(this.genome, housing) || !secondary.isJubilant(this.genome, housing)) {
            return products.toArray(StackUtils.EMPTY_STACK_ARRAY);
        }
        for (Map.Entry entry : primary.getSpecialty().entrySet()) {
            if (!((float)housing.getWorld().field_73012_v.nextInt(100) < (float)((Integer)entry.getValue()).intValue() * speed)) continue;
            products.add(((ItemStack)entry.getKey()).func_77946_l());
        }
        return this.genome.getFlowerProvider().affectProducts(housing.getWorld(), this, housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), products.toArray(StackUtils.EMPTY_STACK_ARRAY));
    }

    @Override
    public IBee spawnPrincess(IBeeHousing housing) {
        if (this.mate == null) {
            return null;
        }
        if (PluginApiculture.beeInterface.getBeekeepingMode(housing.getWorld()).isFatigued(this, housing)) {
            return null;
        }
        return this.createOffspring(housing, this.getGeneration() + 1);
    }

    @Override
    public IBee[] spawnDrones(IBeeHousing housing) {
        World world = housing.getWorld();
        if (this.mate == null) {
            return null;
        }
        ArrayList<IBee> bees = new ArrayList<IBee>();
        int toCreate = PluginApiculture.beeInterface.getBeekeepingMode(world).getFinalFertility(this, world, housing.getXCoord(), housing.getYCoord(), housing.getZCoord());
        if (toCreate <= 0) {
            toCreate = 1;
        }
        for (int i = 0; i < toCreate; ++i) {
            IBee offspring = this.createOffspring(housing, -1);
            if (offspring == null) continue;
            bees.add(offspring);
        }
        if (bees.size() > 0) {
            return bees.toArray(new IBee[0]);
        }
        return null;
    }

    private IBee createOffspring(IBeeHousing housing, int generation) {
        IChromosome[] mutated2;
        World world = housing.getWorld();
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        IChromosome[] mutated1 = this.mutateSpecies(housing, this.genome, this.mate);
        if (mutated1 != null) {
            parent1 = mutated1;
        }
        if ((mutated2 = this.mutateSpecies(housing, this.mate, this.genome)) != null) {
            parent2 = mutated2;
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = Chromosome.inheritChromosome(world.field_73012_v, parent1[i], parent2[i]);
        }
        IBeekeepingMode mode = PluginApiculture.beeInterface.getBeekeepingMode(world);
        Bee offspring = new Bee(world, new BeeGenome(chromosomes), mode.isNaturalOffspring(this), generation);
        return offspring;
    }

    private IChromosome[] mutateSpecies(IBeeHousing housing, IGenome genomeOne, IGenome genomeTwo) {
        IGenome genome1;
        IGenome genome0;
        IAllele allele1;
        IAllele allele0;
        World world = housing.getWorld();
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.field_73012_v.nextBoolean()) {
            allele0 = parent1[EnumBeeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent2[EnumBeeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = parent2[EnumBeeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent1[EnumBeeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        for (IBeeMutation mutation : PluginApiculture.beeInterface.getMutations(true)) {
            float f;
            float chance = 0.0f;
            chance = mutation.getChance(housing, allele0, allele1, genome0, genome1);
            if (!(f > 0.0f) || !(world.field_73012_v.nextFloat() * 100.0f < chance)) continue;
            IApiaristTracker breedingTracker = PluginApiculture.beeInterface.getBreedingTracker(world, housing.getOwnerName());
            breedingTracker.registerMutation(mutation);
            return PluginApiculture.beeInterface.templateAsChromosomes(mutation.getTemplate());
        }
        return null;
    }

    @Override
    public IIndividual retrievePollen(IBeeHousing housing) {
        int chance = (int)((float)this.genome.getFlowering() * housing.getFloweringModifier(this.getGenome(), 1.0f));
        if (housing.getWorld().field_73012_v.nextInt(100) >= chance) {
            return null;
        }
        int[] areaAr = this.genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]).multiply(housing.getTerritoryModifier(this.genome, 1.0f)).multiply(3.0f);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        if (area.x < 1) {
            area.x = 1;
        }
        if (area.y < 1) {
            area.y = 1;
        }
        if (area.z < 1) {
            area.z = 1;
        }
        for (int i = 0; i < 20; ++i) {
            IIndividual pollen;
            Vect randomPos = new Vect(housing.getWorld().field_73012_v.nextInt(area.x), housing.getWorld().field_73012_v.nextInt(area.y), housing.getWorld().field_73012_v.nextInt(area.z));
            Vect posBlock = randomPos.add(new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord()));
            posBlock = posBlock.add(offset);
            TileEntity tile = housing.getWorld().func_72796_p(posBlock.x, posBlock.y, posBlock.z);
            if (!(tile instanceof IPollinatable)) {
                if (housing.getWorld().func_72799_c(posBlock.x, posBlock.y, posBlock.z)) continue;
                for (Map.Entry entry : AlleleManager.ersatzSpecimen.entrySet()) {
                    if (((ItemStack)entry.getKey()).field_77993_c != housing.getWorld().func_72798_a(posBlock.x, posBlock.y, posBlock.z) || ((ItemStack)entry.getKey()).func_77960_j() != housing.getWorld().func_72805_g(posBlock.x, posBlock.y, posBlock.z)) continue;
                    return ((IIndividual)entry.getValue()).copy();
                }
                continue;
            }
            IPollinatable pitcher = (IPollinatable)tile;
            if (!this.genome.getFlowerProvider().isAcceptedPollinatable(housing.getWorld(), pitcher) || (pollen = pitcher.getPollen()) == null) continue;
            return pollen;
        }
        return null;
    }

    @Override
    public boolean pollinateRandom(IBeeHousing housing, IIndividual pollen) {
        int chance = (int)((float)this.genome.getFlowering() * housing.getFloweringModifier(this.getGenome(), 1.0f));
        if (housing.getWorld().field_73012_v.nextInt(100) >= chance) {
            return false;
        }
        int[] areaAr = this.genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]).multiply(housing.getTerritoryModifier(this.genome, 1.0f)).multiply(3.0f);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 4), -Math.round(area.z / 2));
        if (area.x < 1) {
            area.x = 1;
        }
        if (area.y < 1) {
            area.y = 1;
        }
        if (area.z < 1) {
            area.z = 1;
        }
        for (int i = 0; i < 30; ++i) {
            Vect randomPos = new Vect(housing.getWorld().field_73012_v.nextInt(area.x), housing.getWorld().field_73012_v.nextInt(area.y), housing.getWorld().field_73012_v.nextInt(area.z));
            Vect posBlock = randomPos.add(new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord()));
            posBlock = posBlock.add(offset);
            IPollinatable receiver = Utils.getOrCreatePollinatable(housing.getOwnerName(), housing.getWorld(), posBlock.x, posBlock.y, posBlock.z);
            if (receiver == null || !this.genome.getFlowerProvider().isAcceptedPollinatable(housing.getWorld(), receiver) || !receiver.canMateWith(pollen)) continue;
            receiver.mateWith(pollen);
            return true;
        }
        return false;
    }

    @Override
    public void plantFlowerRandom(IBeeHousing housing) {
        int chance = (int)((float)this.genome.getFlowering() * housing.getFloweringModifier(this.getGenome(), 1.0f));
        if (housing.getWorld().field_73012_v.nextInt(100) >= chance) {
            return;
        }
        IFlowerProvider provider = this.genome.getFlowerProvider();
        int[] areaAr = this.genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]).multiply(housing.getTerritoryModifier(this.genome, 1.0f)).multiply(3.0f);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 4), -Math.round(area.z / 2));
        if (area.x < 1) {
            area.x = 1;
        }
        if (area.y < 1) {
            area.y = 1;
        }
        if (area.z < 1) {
            area.z = 1;
        }
        for (int i = 0; i < 10; ++i) {
            Vect randomPos = new Vect(housing.getWorld().field_73012_v.nextInt(area.x), housing.getWorld().field_73012_v.nextInt(area.y), housing.getWorld().field_73012_v.nextInt(area.z));
            Vect posBlock = randomPos.add(new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord()));
            posBlock = posBlock.add(offset);
            if (provider.growFlower(housing.getWorld(), this, posBlock.x, posBlock.y, posBlock.z)) break;
        }
    }
}

