/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.gadgets.BlockAlveary;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.core.utils.DamageSourceForestry;
import forestry.core.utils.Vect;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class AlleleEffectRadioactive
extends AlleleEffectThrottled {
    public static DamageSource damageSourceBeeRadioactive = new DamageSourceForestry("bee.radioactive");

    public AlleleEffectRadioactive(String uid) {
        super(uid, "radioactive", true, 40, false, true);
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        if (this.isHalted(storedData, housing)) {
            return storedData;
        }
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr[0] * 2, areaAr[1] * 2, areaAr[2] * 2);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        Vect min = new Vect(housing.getXCoord() + offset.x, housing.getYCoord() + offset.y, housing.getZCoord() + offset.z);
        Vect max = new Vect(housing.getXCoord() + offset.x + area.x, housing.getYCoord() + offset.y + area.y, housing.getZCoord() + offset.z + area.z);
        AxisAlignedBB hurtBox = AxisAlignedBB.func_72332_a().func_72299_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        List list = housing.getWorld().func_72872_a(EntityLivingBase.class, hurtBox);
        for (Object obj : list) {
            EntityLivingBase entity = (EntityLivingBase)obj;
            int damage = 8;
            if (entity instanceof EntityPlayer) {
                int count = ItemArmorApiarist.wearsItems((EntityPlayer)entity, this.getUID(), true);
                if (count > 3) continue;
                if (count > 2) {
                    damage = 1;
                } else if (count > 1) {
                    damage = 2;
                } else if (count > 0) {
                    damage = 3;
                }
            }
            entity.func_70097_a(damageSourceBeeRadioactive, (float)damage);
        }
        Random rand = housing.getWorld().field_73012_v;
        for (int i = 0; i < 20; ++i) {
            TileEntity tile;
            int id;
            Block block;
            Vect randomPos = new Vect(rand.nextInt(area.x), rand.nextInt(area.y), rand.nextInt(area.z));
            Vect posBlock = randomPos.add(new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord()));
            posBlock = posBlock.add(offset);
            if (posBlock.y <= 1 || posBlock.y >= housing.getWorld().func_72940_L() || posBlock.x == housing.getXCoord() && posBlock.z == housing.getZCoord() && posBlock.y <= housing.getYCoord() || world.func_72799_c(posBlock.x, posBlock.y, posBlock.z) || (block = Block.field_71973_m[id = world.func_72798_a(posBlock.x, posBlock.y, posBlock.z)]) == null || block instanceof BlockAlveary || (tile = world.func_72796_p(posBlock.x, posBlock.y, posBlock.z)) instanceof IBeeHousing || tile instanceof TileAlveary || block.func_71934_m(world, posBlock.x, posBlock.y, posBlock.z) < 0.0f) continue;
            world.func_72832_d(posBlock.x, posBlock.y, posBlock.z, 0, 0, 2);
            break;
        }
        return storedData;
    }
}

