/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.apiculture.genetics.IJubilanceProvider;
import forestry.apiculture.genetics.JubilanceDefault;
import forestry.core.genetics.AlleleSpecies;
import forestry.core.render.TextureManager;
import forestry.core.utils.StackUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class AlleleBeeSpecies
extends AlleleSpecies
implements IAlleleBeeSpecies,
IIconProvider {
    public IJubilanceProvider jubilanceProvider;
    private IBeeRoot root;
    private HashMap products = new HashMap();
    private HashMap specialty = new HashMap();
    private String texture;
    private int primaryColour;
    private int secondaryColour;
    private String iconType = "default";
    @SideOnly(value=Side.CLIENT)
    private static Icon[][] icons;

    public AlleleBeeSpecies(String uid, boolean dominant, String name, IClassification branch, int primaryColor, int secondaryColor) {
        this(uid, dominant, name, branch, null, primaryColor, secondaryColor);
    }

    public AlleleBeeSpecies(String uid, boolean dominant, String name, IClassification branch, String binomial, int primaryColor, int secondaryColor) {
        this(uid, dominant, name, branch, binomial, primaryColor, secondaryColor, new JubilanceDefault());
    }

    public AlleleBeeSpecies(String uid, boolean dominant, String name, IClassification branch, String binomial, int primaryColor, int secondaryColor, IJubilanceProvider jubilanceProvider) {
        super(uid, dominant, name, branch, binomial);
        this.root = (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        this.primaryColour = primaryColor;
        this.secondaryColour = secondaryColor;
        this.jubilanceProvider = jubilanceProvider;
        this.texture = "textures/entity/bees/honeyBee.png";
    }

    @Override
    public IBeeRoot getRoot() {
        return this.root;
    }

    public AlleleBeeSpecies setEntityTexture(String texture) {
        this.texture = "textures/entity/bees/" + texture + ".png";
        return this;
    }

    public AlleleBeeSpecies addProduct(ItemStack product, int chance) {
        this.products.put(product, chance);
        return this;
    }

    public AlleleBeeSpecies addSpecialty(ItemStack specialty, int chance) {
        this.specialty.put(specialty, chance);
        return this;
    }

    public AlleleBeeSpecies setJubilanceProvider(IJubilanceProvider provider) {
        this.jubilanceProvider = provider;
        return this;
    }

    @Override
    public int getComplexity() {
        return 1 + this.getGeneticAdvancement(this, new ArrayList());
    }

    private int getGeneticAdvancement(IAllele species, ArrayList exclude) {
        int own = 1;
        int highest = 0;
        exclude.add(species);
        for (IMutation mutation : this.getRoot().getPaths(species, EnumBeeChromosome.SPECIES.ordinal())) {
            int otherAdvance;
            if (!exclude.contains(mutation.getAllele0()) && (otherAdvance = this.getGeneticAdvancement(mutation.getAllele0(), exclude)) > highest) {
                highest = otherAdvance;
            }
            if (exclude.contains(mutation.getAllele1()) || (otherAdvance = this.getGeneticAdvancement(mutation.getAllele1(), exclude)) <= highest) continue;
            highest = otherAdvance;
        }
        return own + (highest < 0 ? 0 : highest);
    }

    @Override
    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack == null) {
            return 0.0f;
        }
        for (ItemStack stack : this.products.keySet()) {
            if (!stack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        for (ItemStack stack : this.specialty.keySet()) {
            if (!stack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        return super.getResearchSuitability(itemstack);
    }

    @Override
    public ItemStack[] getResearchBounty(World world, String researcher, IIndividual individual, int bountyLevel) {
        ArrayList<ItemStack> bounty = new ArrayList<ItemStack>();
        for (ItemStack stack : super.getResearchBounty(world, researcher, individual, bountyLevel)) {
            bounty.add(stack);
        }
        if (bountyLevel > 10) {
            for (ItemStack stack : this.specialty.keySet()) {
                bounty.add(StackUtils.copyWithRandomSize(stack, (int)((float)bountyLevel / 2.0f), world.field_73012_v));
            }
        }
        for (ItemStack stack : this.products.keySet()) {
            bounty.add(StackUtils.copyWithRandomSize(stack, (int)((float)bountyLevel / 2.0f), world.field_73012_v));
        }
        return bounty.toArray(StackUtils.EMPTY_STACK_ARRAY);
    }

    @Override
    public boolean isNocturnal() {
        return false;
    }

    @Override
    public HashMap getProducts() {
        return this.products;
    }

    @Override
    public HashMap getSpecialty() {
        return this.specialty;
    }

    @Override
    public boolean isJubilant(IBeeGenome genome, IBeeHousing housing) {
        return this.jubilanceProvider.isJubilant(this, genome, housing);
    }

    @Override
    public String getEntityTexture() {
        return this.texture;
    }

    @Override
    public int getIconColour(int renderPass) {
        if (renderPass == 0) {
            return this.primaryColour;
        }
        if (renderPass == 1) {
            return this.secondaryColour;
        }
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister register) {
        icons = new Icon[EnumBeeType.values().length][3];
        Icon body1 = TextureManager.getInstance().registerTex(register, "bees/" + this.iconType + "/body1");
        for (int i = 0; i < EnumBeeType.values().length; ++i) {
            if (EnumBeeType.values()[i] == EnumBeeType.NONE) continue;
            AlleleBeeSpecies.icons[i][0] = TextureManager.getInstance().registerTex(register, "bees/" + this.iconType + "/" + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".outline");
            AlleleBeeSpecies.icons[i][1] = EnumBeeType.values()[i] != EnumBeeType.LARVAE ? body1 : TextureManager.getInstance().registerTex(register, "bees/" + this.iconType + "/" + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".body");
            AlleleBeeSpecies.icons[i][2] = TextureManager.getInstance().registerTex(register, "bees/" + this.iconType + "/" + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".body2");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(EnumBeeType type, int renderPass) {
        return icons[type.ordinal()][renderPass];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(short texUID) {
        return null;
    }
}

