/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.fuels;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class IronEngineFuel {
    public static Map fuels = new HashMap();

    public static Fuel getFuelForFluid(Fluid liquid) {
        return liquid == null ? null : (Fuel)fuels.get(liquid.getName());
    }

    private IronEngineFuel() {
    }

    public static void addFuel(Fluid fluid, float powerPerCycle, int totalBurningTime) {
        fuels.put(fluid.getName(), new Fuel(fluid, powerPerCycle, totalBurningTime));
    }

    public static void addFuel(String fluidName, float powerPerCycle, int totalBurningTime) {
        fuels.put(fluidName, new Fuel(fluidName, powerPerCycle, totalBurningTime));
    }

    public static class Fuel {
        public final Fluid liquid;
        public final float powerPerCycle;
        public final int totalBurningTime;

        private Fuel(String fluidName, float powerPerCycle, int totalBurningTime) {
            this(FluidRegistry.getFluid((String)fluidName), powerPerCycle, totalBurningTime);
        }

        private Fuel(Fluid liquid, float powerPerCycle, int totalBurningTime) {
            this.liquid = liquid;
            this.powerPerCycle = powerPerCycle;
            this.totalBurningTime = totalBurningTime;
        }
    }
}

