/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes;

import com.google.common.base.Optional;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.ModuleControlSettings;
import extrabiomes.module.amica.Amica;
import extrabiomes.module.cautia.Cautia;
import extrabiomes.module.fabrica.Fabrica;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.EventBus;

enum Module {
    CAUTIA(Cautia.class),
    FABRICA(Fabrica.class),
    AMICA(Amica.class);

    private static Optional<EventBus> eventBus;
    private boolean enabled = false;
    private final Class pluginClass;

    public static boolean postEvent(Event event) {
        return eventBus.isPresent() ? ((EventBus)eventBus.get()).post(event) : false;
    }

    static void registerModules() throws InstantiationException, IllegalAccessException {
        for (Module module : Module.values()) {
            switch (module) {
                case CAUTIA: {
                    module.enabled = ModuleControlSettings.CAUTIA.isEnabled();
                    break;
                }
                case FABRICA: {
                    module.enabled = ModuleControlSettings.FABRICA.isEnabled();
                    break;
                }
                case AMICA: {
                    module.enabled = ModuleControlSettings.AMICA.isEnabled();
                }
            }
            LogHelper.info(module.enabled ? "Module %s is enabled." : "Module %s is disabled, skipping.", module.toString());
            if (!module.enabled || !eventBus.isPresent()) continue;
            ((EventBus)eventBus.get()).register(module.pluginClass.newInstance());
        }
    }

    public static void releaseStaticResources() {
        eventBus = Optional.absent();
    }

    private Module(Class pluginClass) {
        this.pluginClass = pluginClass;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    static {
        eventBus = Optional.of((Object)new EventBus());
    }
}

