/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.uu;

import ic2.api.recipe.Recipes;
import ic2.core.util.StackUtil;
import ic2.core.uu.ForgeCraftingResolver;
import ic2.core.uu.IRecipeResolver;
import ic2.core.uu.Ic2CraftingResolver;
import ic2.core.uu.MachineRecipeResolver;
import ic2.core.uu.RecipeTransformation;
import ic2.core.uu.VanillaCraftingResolver;
import ic2.core.uu.VanillaSmeltingResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class UuIndex {
    public static final UuIndex instance = new UuIndex();
    private final Map<Integer, IdEntry> index = new HashMap<Integer, IdEntry>();
    private final List<IRecipeResolver> resolvers = new ArrayList<IRecipeResolver>();

    private UuIndex() {
    }

    public void addResolver(IRecipeResolver resolver) {
        this.resolvers.add(resolver);
    }

    public void add(ItemStack stack, double value) {
        this.add(stack, new IndexValue(value, false), true);
    }

    private void add(ItemStack stack, IndexValue value, boolean force) {
        if (stack.func_77960_j() == Short.MAX_VALUE) {
            throw new IllegalArgumentException("wildcard ItemStacks must not be added");
        }
        IdEntry idEntry = this.getIdEntry(stack);
        idEntry.add(stack, value, force);
    }

    public double get(ItemStack request) {
        System.out.println("1: " + this.get2(request));
        for (IdEntry idEntry : this.index.values()) {
            for (IndexValue value : idEntry.damageValues.values()) {
                value.weak = true;
            }
        }
        System.out.println("2: " + this.get2(request));
        for (IdEntry idEntry : this.index.values()) {
            for (IndexValue value : idEntry.damageValues.values()) {
                value.weak = true;
            }
        }
        System.out.println("3: " + this.get2(request));
        return this.get2(request);
    }

    private double get2(ItemStack request) {
        ItemStack stack = this.fixSize(request);
        IdEntry idEntry = this.getIdEntry(stack);
        IndexValue ret = idEntry.get(stack);
        if (ret == null || ret.weak) {
            boolean hasBlockingEntry;
            boolean bl = hasBlockingEntry = ret == null;
            if (hasBlockingEntry) {
                ret = new IndexValue(Double.POSITIVE_INFINITY, false);
                idEntry.add(stack, ret, true);
            } else {
                ret.weak = false;
            }
            ItemStack minStack = null;
            List<ItemStack> byproducts = null;
            for (IRecipeResolver resolver : this.resolvers) {
                List<RecipeTransformation> transformations = resolver.getTransformations(stack);
                for (RecipeTransformation transformation : transformations) {
                    assert (transformation.output.field_77993_c == stack.field_77993_c);
                    assert (!transformation.inputs.isEmpty());
                    double value = 0.0;
                    for (List<ItemStack> inputs : transformation.inputs) {
                        double minValue = Double.POSITIVE_INFINITY;
                        for (ItemStack input : inputs) {
                            double cValue = this.get2(input) / ((double)transformation.output.field_77994_a * transformation.outputMultiplier);
                            if (!(cValue < minValue)) continue;
                            minValue = cValue;
                        }
                        value += minValue;
                    }
                    if (!(value < ret.value)) continue;
                    ret.value = value;
                    minStack = this.fixSize(transformation.output);
                    byproducts = transformation.byproducts;
                }
            }
            if (minStack != null) {
                if (stack.func_77960_j() == Short.MAX_VALUE) {
                    idEntry.remove(stack);
                    idEntry.add(minStack, ret, true);
                } else assert (stack.func_77960_j() == minStack.func_77960_j()) : stack + " <-> " + minStack;
                if (byproducts != null) {
                    // empty if block
                }
            }
        }
        return ret.value * (double)request.field_77994_a;
    }

    public void load() {
        this.addResolver(new VanillaCraftingResolver());
        this.addResolver(new VanillaSmeltingResolver());
        this.addResolver(new Ic2CraftingResolver());
        this.addResolver(new ForgeCraftingResolver());
        this.addResolver(new MachineRecipeResolver(Recipes.macerator));
        this.addResolver(new MachineRecipeResolver(Recipes.oreWashing));
    }

    public void save() {
    }

    public void clear() {
        this.index.clear();
    }

    private IdEntry getIdEntry(ItemStack stack) {
        IdEntry ret = this.index.get(stack.field_77993_c);
        if (ret == null) {
            ret = new IdEntry();
            this.index.put(stack.field_77993_c, ret);
        }
        return ret;
    }

    private ItemStack fixSize(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            return stack;
        }
        return StackUtil.copyWithSize(stack, 1);
    }

    static class IndexValue {
        double value;
        boolean weak;

        IndexValue(double value, boolean weak) {
            this.value = value;
            this.weak = weak;
        }
    }

    static class StackDamageWrapper {
        ItemStack stack;

        public StackDamageWrapper(ItemStack stack) {
            this.stack = stack;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StackDamageWrapper) {
                StackDamageWrapper x = (StackDamageWrapper)obj;
                return x.stack.func_77960_j() == this.stack.func_77960_j() && ItemStack.func_77970_a((ItemStack)x.stack, (ItemStack)this.stack);
            }
            return false;
        }

        public int hashCode() {
            return this.stack.func_77960_j();
        }

        public String toString() {
            return this.stack.toString();
        }
    }

    static class IdEntry {
        IndexValue wildcardValue;
        Map<StackDamageWrapper, IndexValue> damageValues = new HashMap<StackDamageWrapper, IndexValue>();

        IdEntry() {
        }

        void add(ItemStack stack, IndexValue value, boolean force) {
            StackDamageWrapper key = new StackDamageWrapper(stack);
            IndexValue oldValue = this.damageValues.get(key);
            if (oldValue == null || value.value < oldValue.value || force) {
                this.damageValues.put(key, value);
                if (stack.func_77960_j() != Short.MAX_VALUE) {
                    this.remove(new ItemStack(stack.field_77993_c, 1, Short.MAX_VALUE));
                } else assert (this.damageValues.size() == 1) : stack + " -> " + this.damageValues.keySet();
            }
            this.wildcardValue = null;
        }

        void remove(ItemStack stack) {
            this.damageValues.remove(new StackDamageWrapper(stack));
            this.wildcardValue = null;
        }

        IndexValue get(ItemStack stack) {
            if (stack.func_77960_j() == Short.MAX_VALUE) {
                if (this.wildcardValue == null) {
                    for (IndexValue value : this.damageValues.values()) {
                        if (this.wildcardValue != null && !(value.value < this.wildcardValue.value)) continue;
                        this.wildcardValue = value;
                    }
                }
                return this.wildcardValue;
            }
            return this.damageValues.get(new StackDamageWrapper(stack));
        }
    }
}

