/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.uu;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.core.util.StackUtil;
import ic2.core.uu.IRecipeResolver;
import ic2.core.uu.RecipeTransformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class MachineRecipeResolver
implements IRecipeResolver {
    private final IMachineRecipeManager manager;

    public MachineRecipeResolver(IMachineRecipeManager manager) {
        this.manager = manager;
    }

    @Override
    public List<RecipeTransformation> getTransformations(ItemStack output) {
        ArrayList<RecipeTransformation> ret = new ArrayList<RecipeTransformation>();
        Map<IRecipeInput, RecipeOutput> recipes = this.manager.getRecipes();
        block0: for (Map.Entry<IRecipeInput, RecipeOutput> entry : recipes.entrySet()) {
            List<ItemStack> outputs = entry.getValue().items;
            for (int i = 0; i < outputs.size(); ++i) {
                List<ItemStack> inputs;
                ItemStack realOutput = outputs.get(i);
                if (!this.matches(realOutput, output) || (inputs = entry.getKey().getInputs()).isEmpty()) continue;
                int amount = entry.getKey().getAmount();
                ArrayList<ItemStack> byproducts = null;
                if (outputs.size() > 1) {
                    byproducts = new ArrayList<ItemStack>(outputs.size() - 1);
                    for (int j = 0; j < outputs.size(); ++j) {
                        if (j == i) continue;
                        byproducts.add(outputs.get(j));
                    }
                }
                ret.add(new RecipeTransformation(this.fixSizeExpand(inputs, amount), realOutput, byproducts));
                continue block0;
            }
        }
        return ret;
    }

    private boolean matches(ItemStack offer, ItemStack requirement) {
        return offer.field_77993_c == requirement.field_77993_c && (requirement.func_77960_j() == Short.MAX_VALUE || offer.func_77960_j() == requirement.func_77960_j());
    }

    private List<List<ItemStack>> fixSizeExpand(List<ItemStack> x, int size) {
        ArrayList[] ret = new ArrayList[x.size()];
        for (int i = 0; i < x.size(); ++i) {
            ret[i] = new ArrayList(1);
            ItemStack stack = x.get(i);
            if (stack.field_77994_a == size) {
                ret[i].add(stack);
                continue;
            }
            ret[i].add(StackUtil.copyWithSize(stack, size));
        }
        return Arrays.asList(ret);
    }
}

