/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.Resource;
import net.minecraft.client.resources.ResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class BlockTextureStitched
extends TextureAtlasSprite {
    private final int subIndex;
    private AnimationMetadataSection animationMeta;
    private BufferedImage comparisonImage;
    private TextureAtlasSprite mappedTexture;
    private static Map<String, CacheEntry> cachedImages = new HashMap<String, CacheEntry>();
    private static Map<Integer, List<BlockTextureStitched>> existingTextures = new HashMap<Integer, List<BlockTextureStitched>>();

    public BlockTextureStitched(String name, int subIndex1) {
        super(name);
        this.subIndex = subIndex1;
    }

    public void func_94217_a(TextureAtlasSprite textureStitched) {
        if (textureStitched.func_94215_i().equals("missingno") && this.mappedTexture != null) {
            super.func_94217_a(this.mappedTexture);
        } else {
            super.func_94217_a(textureStitched);
        }
    }

    public void func_94219_l() {
    }

    public boolean load(ResourceManager manager, ResourceLocation location) throws IOException {
        String name = location.func_110623_a();
        int index = name.indexOf(58);
        if (index != -1) {
            int extStart = name.lastIndexOf(46);
            location = new ResourceLocation(location.func_110624_b(), name.substring(0, index) + name.substring(extStart));
        }
        return this.loadSubImage(manager.func_110536_a(location));
    }

    public boolean loadSubImage(Resource res) throws IOException {
        AnimationMetadataSection animationMeta1;
        BufferedImage bufferedImage;
        String name = this.func_94215_i();
        CacheEntry cacheEntry = cachedImages.get(name);
        if (cacheEntry != null) {
            bufferedImage = cacheEntry.image;
            animationMeta1 = cacheEntry.animationMeta;
        } else {
            bufferedImage = ImageIO.read(res.func_110527_b());
            animationMeta1 = (AnimationMetadataSection)res.func_110526_a("animation");
            cachedImages.put(name, new CacheEntry(bufferedImage, animationMeta1));
        }
        int animationLength = 1;
        if (animationMeta1 != null && animationMeta1.func_110471_a() > 0) {
            animationLength = animationMeta1.func_110471_a();
            this.animationMeta = animationMeta1;
            try {
                Field parentAnimationMeta = TextureAtlasSprite.class.getDeclaredField("field_110982_k");
                parentAnimationMeta.setAccessible(true);
                parentAnimationMeta.set((Object)this, animationMeta1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        int size = bufferedImage.getHeight() / animationLength;
        int count = bufferedImage.getWidth() / size;
        int index = this.subIndex;
        if (count == 1 || count == 6 || count == 12) {
            index %= count;
        } else if (count == 2) {
            index /= 6;
        } else {
            IC2.log.warning("texture " + name + " is not properly sized");
            throw new IOException();
        }
        this.field_130223_c = size;
        this.field_130224_d = size;
        return this.loadFrames(bufferedImage, index, animationLength);
    }

    public Icon getRealTexture() {
        return this.mappedTexture == null ? this : this.mappedTexture;
    }

    private boolean loadFrames(BufferedImage image, int index, int animationLength) {
        int totalHeight = this.field_130224_d * animationLength;
        this.comparisonImage = image.getSubimage(index * this.field_130223_c, 0, this.field_130223_c, totalHeight);
        int[] rgbaData = new int[this.field_130223_c * totalHeight];
        this.comparisonImage.getRGB(0, 0, this.field_130223_c, totalHeight, rgbaData, 0, this.field_130223_c);
        int hash = Arrays.hashCode(rgbaData);
        List<BlockTextureStitched> matchingTextures = existingTextures.get(hash);
        if (matchingTextures != null) {
            int[] rgbaData2 = new int[this.field_130223_c * totalHeight];
            for (BlockTextureStitched matchingTexture : matchingTextures) {
                if (matchingTexture.comparisonImage.getWidth() != this.field_130223_c || matchingTexture.comparisonImage.getHeight() != totalHeight) continue;
                matchingTexture.comparisonImage.getRGB(0, 0, this.field_130223_c, totalHeight, rgbaData2, 0, this.field_130223_c);
                if (!Arrays.equals(rgbaData, rgbaData2)) continue;
                this.mappedTexture = matchingTexture;
                return false;
            }
            matchingTextures.add(this);
        } else {
            matchingTextures = new ArrayList<BlockTextureStitched>();
            matchingTextures.add(this);
            existingTextures.put(hash, matchingTextures);
        }
        int pixelsPerFrame = this.field_130223_c * this.field_130224_d;
        if (this.animationMeta != null && this.animationMeta.func_110473_c() > 0) {
            for (Integer frameIndex : this.animationMeta.func_130073_e()) {
                if (frameIndex >= animationLength) {
                    throw new RuntimeException("invalid frame index: " + frameIndex + " (" + this.func_94215_i() + ")");
                }
                while (this.field_110976_a.size() <= frameIndex) {
                    this.field_110976_a.add(null);
                }
                this.field_110976_a.set(frameIndex, Arrays.copyOfRange(rgbaData, frameIndex * pixelsPerFrame, (frameIndex + 1) * pixelsPerFrame));
            }
        } else {
            for (int i = 0; i < animationLength; ++i) {
                this.field_110976_a.add(Arrays.copyOfRange(rgbaData, i * pixelsPerFrame, (i + 1) * pixelsPerFrame));
            }
        }
        return true;
    }

    public static void onPostStitch() {
        for (List<BlockTextureStitched> textures : existingTextures.values()) {
            for (BlockTextureStitched texture : textures) {
                texture.comparisonImage = null;
            }
        }
        cachedImages.clear();
        existingTextures.clear();
    }

    static class CacheEntry {
        final BufferedImage image;
        final AnimationMetadataSection animationMeta;

        CacheEntry(BufferedImage image1, AnimationMetadataSection animationMeta1) {
            this.image = image1;
            this.animationMeta = animationMeta1;
        }
    }
}

